import React from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {CloseButton} from '@blocks/pushes/components/CloseButton/CloseButton';
import {cn} from '@bem-react/classname';
import metrics from '@blocks/metrics';
import {
    WEB_CARD_AUTOLOGIN,
    WEB_CARD_AUTOLOGIN_SHOWN,
    WEB_CARD_AUTOLOGIN_CHANGE_ACCOUNT,
    WEB_CARD_AUTOLOGIN_CLOSED,
    WEB_CARD_AUTOLOGIN_SUCCESS,
    WEB_CARD_AUTOLOGIN_ERROR
} from '@blocks/pushes/metrics_constants';
import './TurboAppLogin.styl';

const b = cn('TurboAppLogin');

const CHOSE_ACCOUNT_MASK = 99;

class TurboAppLogin extends React.PureComponent {
    componentDidMount() {
        const {isAccountError, finishErrorUrl} = this.props;

        if (isAccountError) {
            metrics.send([WEB_CARD_AUTOLOGIN, WEB_CARD_AUTOLOGIN_ERROR]);
            window.location.href = finishErrorUrl;
            return;
        }

        metrics.send([WEB_CARD_AUTOLOGIN, WEB_CARD_AUTOLOGIN_SHOWN]);
    }

    _closePopup = () => {
        const {finishCancelUrl} = this.props;

        metrics.send([WEB_CARD_AUTOLOGIN, WEB_CARD_AUTOLOGIN_CLOSED]);
        window.location.href = finishCancelUrl;
    };

    _openAccountsList = () => {
        const {hasUnitedAccounts, chooseAccount} = this.props;

        if (hasUnitedAccounts) {
            metrics.send([WEB_CARD_AUTOLOGIN, WEB_CARD_AUTOLOGIN_CHANGE_ACCOUNT]);
            chooseAccount(CHOSE_ACCOUNT_MASK);
        }
    };

    _onSubmit = () => {
        const {primaryActionTriggered} = this.props;

        metrics.send([WEB_CARD_AUTOLOGIN, WEB_CARD_AUTOLOGIN_SUCCESS]);
        primaryActionTriggered();
    };

    render() {
        const {name, avatarLink, isAccountError} = this.props;

        const avatarStyle = {
            backgroundImage: avatarLink
        };

        if (isAccountError) {
            return null;
        }

        return (
            <div className={b('wrapper')}>
                <div className={b('content')}>
                    <div className={b('close')}>
                        <CloseButton closeHandler={this._closePopup} mode='relative' />
                    </div>

                    <div className={b('avatarWrapper')}>
                        <span className={b('avatar')} style={avatarStyle} />
                    </div>

                    <div className={b('welcome')}>
                        <div className={b('welcomeItem')}>
                            {i18n('_AUTH_.auth.turbo-login-welcome')} {name},
                        </div>
                        <div className={b('welcomeItem')}>{i18n('Frontend.auth.turbo-login-welcome-answer')}</div>
                    </div>

                    <div data-t='push_submit_qr' className={b('submitButton')}>
                        <Button type='button' view='action' size='l' width='max' onClick={this._onSubmit}>
                            {i18n('Frontend.auth.turbo-login-enter-as')} {name}
                        </Button>
                    </div>

                    <div data-t='push_open_account_list' className={b('carouselButton')}>
                        <Button type='button' view='action' size='l' width='max' onClick={this._openAccountsList}>
                            {i18n('Frontend.auth.turbo-login-another-account')}
                        </Button>
                    </div>
                </div>
            </div>
        );
    }
}

TurboAppLogin.propTypes = {
    name: PropTypes.string,
    avatarLink: PropTypes.string,
    closeAmPopup: PropTypes.func.isRequired,
    chooseAccount: PropTypes.func.isRequired,
    primaryActionTriggered: PropTypes.func.isRequired,
    hasUnitedAccounts: PropTypes.bool,
    trackId: PropTypes.string,
    isAccountError: PropTypes.bool,
    finishCancelUrl: PropTypes.string.isRequired,
    finishErrorUrl: PropTypes.string.isRequired
};

export {TurboAppLogin};
