import {connect} from 'react-redux';
import {TurboAppLogin} from './TurboAppLogin';
import {withResize} from '../hocs/withResize';
import {
    closeAmPopup,
    chooseAccount,
    primaryActionTriggered,
    setPopupSize
} from '@blocks/authv2/actions/nativeMobileApi';

const mapStateToProps = (state = {}) => {
    const {turboAppLogin = {}, am = {}, settings = {}, auth = {}} = state;
    const {avatar} = settings;
    const {host, pathname} = avatar;
    const {uid, trackId, finishCancelUrl, finishErrorUrl} = am;
    const {unitedAccounts, defaultAccount} = auth;
    const hasUnitedAccounts = Object.keys(auth.unitedAccounts).length !== 0;
    const currentAccount = unitedAccounts[uid] || defaultAccount || null;

    if (currentAccount) {
        const {login, name, displayName, avatarId} = currentAccount;

        const avatarLink = `url("https://${host}${pathname
            .replace('%uid%', avatarId)
            .replace('%size%', '200')
            .replace('%login%', login)}")`;

        return {
            turboAppLogin,
            name: name || displayName,
            hasUnitedAccounts,
            avatarLink,
            trackId,
            finishCancelUrl,
            finishErrorUrl,
            isAccountError: false
        };
    }

    return {
        turboAppLogin,
        isAccountError: true,
        finishCancelUrl,
        finishErrorUrl
    };
};

const mapDispatchToProps = {
    closeAmPopup,
    chooseAccount,
    primaryActionTriggered,
    setPopupSize
};

const connectedTurboAppLogin = connect(mapStateToProps, mapDispatchToProps)(withResize(TurboAppLogin));

export {connectedTurboAppLogin as TurboAppLogin};
