import React from 'react';
import PropTypes from 'prop-types';
import {CloseIcon} from '../../icons/CloseIcon/CloseIcon';
import {cn} from '@bem-react/classname';
import './CloseButton.styl';

const b = cn('CloseButton');

export const CloseButton = ({mode = '', closeHandler}) => (
    <button className={b('', {mode})} aria-label={i18n('Frontend.close')} onClick={closeHandler}>
        <CloseIcon />
    </button>
);

CloseButton.propTypes = {
    mode: PropTypes.oneOf(['relative']),
    closeHandler: PropTypes.func.isRequired
};
