import React, {Component} from 'react';
import PropTypes from 'prop-types';
import ResizeObserver from 'resize-observer-polyfill';

const POPUP_OPTIONS_DEFAULT = {
    mode: 'bottom',
    cornerRadius: 20,
    horizontalMargins: 16,
    verticalMargins: 16,
    height: 0
};

export const withResize = (WrappedComponent, popupOptions = null) => {
    return class extends Component {
        resizeObserver = null;
        popup = React.createRef();
        state = {popupHeight: 0};

        componentDidMount() {
            const popupElem = this.popup.current;

            this.resizeObserver = new ResizeObserver(this._resizeCallback);
            this.resizeObserver.observe(popupElem);
        }

        componentWillUnmount() {
            if (this.resizeObserver) {
                this.resizeObserver.disconnect();
            }
        }

        _resizeCallback = (entries) => {
            const {setPopupSize} = this.props;
            const popupElem = this.popup.current;
            const popup = entries[0].target;
            const {clientHeight: popupHeight} = popup;

            const modifiedDefaultOptions = {...POPUP_OPTIONS_DEFAULT, height: popupElem.clientHeight};

            const resOptions = popupOptions || modifiedDefaultOptions;

            if (popupHeight !== this.state.popupHeight) {
                this.setState({popupHeight});
                setPopupSize(resOptions);
            }
        };

        render() {
            return (
                <div ref={this.popup}>
                    <WrappedComponent {...this.props} />
                </div>
            );
        }

        propTypes = {
            setPopupSize: PropTypes.func.isRequired
        };
    };
};
