import React from 'react';
import {connect} from 'react-redux';
import classnames from 'classnames';
import PropTypes from 'prop-types';
import {AppPromo} from '@blocks/registration/app-promo';
import Qr from '@blocks/qr-registration/components/Qr/Qr.jsx';
import Header from '@components/Header/Header.jsx';
import mapStateToProps from './mapStateToProps';

export class Page extends React.PureComponent {
    render() {
        const {isMobile} = this.props;

        return (
            <div>
                <Header hideNavigation={true} />

                <div
                    className={classnames({
                        'main-container': !isMobile,
                        is_mobile_reg: isMobile,
                        'mobile_unified-experiment': isMobile
                    })}
                >
                    <AppPromo />
                    <main className={classnames('registration__wrapper', {registration__wrapper_desktop: !isMobile})}>
                        <Qr />
                    </main>
                </div>
            </div>
        );
    }
}

Page.propTypes = {
    isMobile: PropTypes.bool.isRequired,
    header: PropTypes.object,
    common: PropTypes.shape({
        yandexuid: PropTypes.string
    }).isRequired,
    settings: PropTypes.shape({
        tld: PropTypes.string,
        avatar: PropTypes.shape({
            host: PropTypes.string
        }),
        host: PropTypes.string,
        language: PropTypes.string
    }).isRequired
};

export default connect(mapStateToProps)(Page);
