import {combineReducers} from 'redux';
import header from '@blocks/morda/components/header/reducers';
import person from '@blocks/morda/personal_info/reducers.js';
import social from '@blocks/morda/social_info/reducers';
import emails from '@blocks/morda/emails/reducers';
import security from '@blocks/morda/security/reducers';
import domik from '@blocks/morda/components/domik/reducers';
import common from '@blocks/common/reducers';
import captcha from '@components/Captcha/reducers';
import access from '@blocks/morda/access/reducers';
import yamoney from '@blocks/morda/components/money/reducers';
import addresses from '@blocks/morda/addresses/reducers';
import changeAvatar from '@blocks/morda/avatar/reducers';
import appPasswords from '@blocks/morda/create_app_passwords/reducers';
import devices from '@blocks/morda/devices/reducers';
import {authDevice} from '@blocks/AuthDevice/reducers';
import alice from '@blocks/morda/new/other_settings_block/alice/actions/reducers';
import {subs} from '@blocks/Subs/reducer';
import tracks from '@blocks/reducers/tracks';

const stub = (state = {}) => state;

const rootReducer = combineReducers({
    common,
    header,
    access,
    settings: stub,
    footer: stub,
    metrics: stub,
    monitoring: stub,
    domik,
    person,
    social,
    captcha,
    security,
    yamoney,
    addresses,
    emails,
    billing: stub,
    changeAvatar,
    appPasswords,
    devices,
    authDevice,
    alice,
    tracks,
    subs
});

export default rootReducer;
