import {CHANGE_PWD_INIT, CHANGE_PWD_DONE, CHANGE_PWD_GLOGOUT} from '@blocks/actions/changePassword';

const initialState = {
    revokers: {},
    hasPasswordChanged: false,
    isGlobalLogoutChecked: false
};

const changePassword = (state = initialState, action = {}) => {
    const {type = {}} = action;

    switch (type) {
        case CHANGE_PWD_INIT: {
            return Object.assign({}, state, {
                revokers: action.revokers,
                hasPasswordChanged: false
            });
        }

        case CHANGE_PWD_DONE: {
            return Object.assign({}, state, {
                hasPasswordChanged: true
            });
        }

        case CHANGE_PWD_GLOGOUT: {
            return Object.assign({}, state, {
                isGlobalLogoutChecked: action.payload
            });
        }

        default: {
            return state;
        }
    }
};

export default changePassword;
