import {
    CONFIRMATION_CODE_SENT,
    CONFIRMATION_CODE_CHECKED,
    CLEAR_EMAIL_EDIT_STATE,
    MARK_EMAIL_DELETED,
    UNMARK_EMAIL_DELETED,
    SET_DELETE_DONE
} from '@blocks/actions/editEmails';

const initialState = {
    hasCodeSent: false,
    hasCodeChecked: false,
    hasDeleteDone: false,
    emailsToDelete: []
};

export default function editEmails(state = initialState, action) {
    switch (action.type) {
        case CONFIRMATION_CODE_SENT: {
            return Object.assign({}, state, {
                hasCodeSent: true
            });
        }
        case CONFIRMATION_CODE_CHECKED: {
            return Object.assign({}, state, {
                hasCodeChecked: true
            });
        }
        case CLEAR_EMAIL_EDIT_STATE: {
            return Object.assign({}, state, {
                hasCodeSent: false,
                hasCodeChecked: false,
                hasDeleteDone: false,
                emailsToDelete: []
            });
        }
        case MARK_EMAIL_DELETED: {
            return Object.assign({}, state, {
                emailsToDelete: [...state.emailsToDelete, action.email]
            });
        }
        case UNMARK_EMAIL_DELETED: {
            const updatedList = state.emailsToDelete.filter((email) => email !== action.email);

            return Object.assign({}, state, {
                emailsToDelete: updatedList
            });
        }
        case SET_DELETE_DONE: {
            return Object.assign({}, state, {
                hasDeleteDone: true,
                emailsToDelete: []
            });
        }
        default:
            return state;
    }
}
