import {
    UPDATE_ERRORS,
    UPDATE_ERRORS_VALID,
    SET_GROUP_ERRORS,
    UPDATE_GLOBAL_HINT_STATUS,
    SET_FIELD_ERROR_ACTIVE,
    CLEAR_FORM
} from '@blocks/actions/form';

const initialState = {
    active: '',
    hintActive: false,
    firstname: {
        code: '',
        text: ''
    },
    lastname: {
        code: '',
        text: ''
    },
    login: {
        code: '',
        text: ''
    },
    email: {
        code: '',
        text: ''
    },
    password: {
        code: '',
        text: '',
        warning: false
    },
    password_confirm: {
        code: '',
        text: ''
    },
    hint_question_id: {
        code: '',
        text: ''
    },
    hint_question: {
        code: '',
        text: ''
    },
    hint_question_custom: {
        code: '',
        text: ''
    },
    hint_answer: {
        code: '',
        text: ''
    },
    captcha: {
        code: '',
        text: ''
    },
    phone: {
        code: '',
        text: ''
    },
    phoneCode: {
        code: '',
        text: ''
    },
    phoneCodeStatus: '',
    birthday: {
        code: '',
        text: ''
    }
};

export default function errors(state = initialState, action) {
    // eslint-disable-line complexity
    switch (action.type) {
        case UPDATE_ERRORS: {
            const updatedState = Object.assign({}, state, {
                active: action.data.active ? action.data.field : '',
                [action.data.field]: action.data.error,
                errorDescription: action.data.errorDescription || ''
            });

            if (action.data.warning) {
                updatedState.warning = action.data.warning;
            }

            if (!action.data.active && action.data.field !== state.active) {
                updatedState.active = state.active;
            }

            return updatedState;
        }
        case UPDATE_ERRORS_VALID: {
            return Object.assign({}, state, {
                active: state.active === action.field ? '' : state.active,
                errorDescription: '',
                [action.field]: {
                    code: '',
                    text: ''
                }
            });
        }
        case SET_GROUP_ERRORS: {
            return Object.assign({}, state, action.data);
        }
        case UPDATE_GLOBAL_HINT_STATUS: {
            return Object.assign({}, state, {
                hintActive: action.status
            });
        }
        case SET_FIELD_ERROR_ACTIVE: {
            return Object.assign({}, state, {
                active: action.field
            });
        }
        case CLEAR_FORM: {
            return initialState;
        }
        default:
            return state;
    }
}
