import {
    UPDATE_EMPTY_ERRORS,
    UPDATE_HINT_CUSTOM_QUESTION_STATE,
    UPDATE_HINT_QUESTION_STATES,
    UPDATE_PHONE_CODE_STATE,
    UPDATE_PHONE_STATES_TO_DEFAULTS,
    UPDATE_STATES,
    CLEAR_FORM
} from '@blocks/actions/form';

const initialState = {
    firstname: '',
    lastname: '',
    login: '',
    email: '',
    password: '',
    password_confirm: '',
    hint_question_id: '',
    hint_question: '',
    hint_question_custom: 'valid',
    hint_answer: '',
    captcha: '',
    phone: '',
    phoneCode: '',
    phoneCodeStatus: '',
    gender: 'valid',
    birthday: ''
};

export default function states(state = initialState, action) {
    switch (action.type) {
        case UPDATE_STATES: {
            return Object.assign({}, state, {
                [action.data.field]: action.data.status
            });
        }
        case UPDATE_HINT_QUESTION_STATES: {
            return Object.assign({}, state, {
                hint_question: action.data.status,
                hint_question_id: action.data.status
            });
        }
        case UPDATE_HINT_CUSTOM_QUESTION_STATE: {
            return Object.assign({}, state, {
                hint_question_custom: action.data.status
            });
        }
        case UPDATE_PHONE_CODE_STATE: {
            return Object.assign({}, state, {
                phoneCode: action.status
            });
        }
        case UPDATE_PHONE_STATES_TO_DEFAULTS: {
            return Object.assign({}, state, {
                phone: '',
                phoneCode: '',
                phoneCodeStatus: ''
            });
        }
        case UPDATE_EMPTY_ERRORS: {
            return Object.assign({}, state, action.fields);
        }
        case CLEAR_FORM: {
            return initialState;
        }
        default:
            return state;
    }
}
