import {
    CHANGE_CALL_CONFIRMATION_PROCESS,
    CHANGE_PHONE_CONFIRMATION_TYPE,
    FORCE_CHECKED_CONFIRMATION_CODE,
    HUMAN_CONFIRMATION_DONE,
    SET_CALL_CONFIRMATION_TIMER,
    SET_CONFIRMATION_CODE_LENGTH,
    SET_MAGIC_CONFIRMATION_CODE,
    UPDATE_VALIDATION_METHOD,
    VALIDATE_PHONE_FOR_CALL,
    CLEAR_FORM
} from '@blocks/actions/form';
import {EMAIL_CONFIRMATION_DONE} from '@blocks/registration-lite/actions';

const initialState = {
    method: 'phone',
    humanConfirmationDone: false
};

export default function formValidation(state = initialState, action) {
    switch (action.type) {
        case UPDATE_VALIDATION_METHOD: {
            return Object.assign({}, state, {
                method: action.method
            });
        }
        case HUMAN_CONFIRMATION_DONE: {
            return Object.assign({}, state, {
                humanConfirmationDone: action.state
            });
        }
        case EMAIL_CONFIRMATION_DONE: {
            return Object.assign({}, state, {
                emailConfirmationDone: action.state
            });
        }
        case VALIDATE_PHONE_FOR_CALL: {
            return Object.assign({}, state, {
                isValidPhoneForCall: action.isValid
            });
        }
        case CHANGE_PHONE_CONFIRMATION_TYPE: {
            return Object.assign({}, state, {
                phoneConfirmationType: action.phoneConfirmationType
            });
        }
        case SET_MAGIC_CONFIRMATION_CODE: {
            return Object.assign({}, state, {
                magicConfirmationCode: action.code
            });
        }
        case SET_CALL_CONFIRMATION_TIMER: {
            return Object.assign({}, state, {
                callConfirmationTimer: action.timer
            });
        }
        case CHANGE_CALL_CONFIRMATION_PROCESS: {
            return Object.assign({}, state, {
                isCallConfirmationInProcess: action.process
            });
        }
        case FORCE_CHECKED_CONFIRMATION_CODE: {
            return Object.assign({}, state, {
                isForceCheckedConfirmationCode: true
            });
        }
        case SET_CONFIRMATION_CODE_LENGTH: {
            return Object.assign({}, state, {
                confirmationCodeLength: action.codeLength
            });
        }
        case CLEAR_FORM: {
            return initialState;
        }
        default:
            return state;
    }
}
