import {UPDATE_PHONE_VALUES_TO_DEFAULTS, UPDATE_QUESTION_VALUES, UPDATE_VALUES, CLEAR_FORM} from '@blocks/actions/form';

const initialState = {
    name: '',
    firstname: '',
    lastname: '',
    surname: '',
    login: '',
    email: '',
    password: '',
    password_confirm: '',
    hint_question_id: '',
    hint_question: '',
    hint_question_custom: '',
    hint_answer: '',
    captcha: '',
    phone: '',
    phoneCode: '',
    publicId: '',
    gender: 'm',
    birthday: ''
};

export default function values(state = initialState, action) {
    switch (action.type) {
        case UPDATE_VALUES: {
            return Object.assign({}, state, {
                [action.data.field]: action.data.value
            });
        }
        case UPDATE_PHONE_VALUES_TO_DEFAULTS: {
            return Object.assign({}, state, {
                phone: '',
                phoneCode: ''
            });
        }
        case UPDATE_QUESTION_VALUES: {
            return Object.assign({}, state, {
                hint_question_id: action.data.hint_question_id,
                hint_question: action.data.hint_question
            });
        }
        case CLEAR_FORM: {
            return initialState;
        }
        default:
            return state;
    }
}
