import {GET_QUESTIONS_LIST, UPDATE_CONFIRMATION_FETCHING_STATUS, SET_CAPTCHA_REQUIRED} from '@blocks/actions/form';

export default function humanConfirmation(state = {}, action) {
    switch (action.type) {
        case GET_QUESTIONS_LIST: {
            return Object.assign({}, state, {
                questionList: action.questions
            });
        }
        case UPDATE_CONFIRMATION_FETCHING_STATUS: {
            return Object.assign({}, state, {
                isFetching: action.data.isFetching
            });
        }
        case SET_CAPTCHA_REQUIRED: {
            return Object.assign({}, state, {
                isCaptchaRequired: action.isRequired
            });
        }
        default:
            return state;
    }
}
