import {combineReducers} from 'redux';
import states from './formStates';
import values from './formValues';
import errors from './formErrors';
import validation from './formValidation';
import humanConfirmation from './humanConfirmation';
import {
    CHANGE_ACTIVE_FIELD,
    SET_CAPTCHA_REQUIRED,
    SET_PASSWORD_WEIGHT,
    TOGGLE_PASSWORD_VISIBILITY_STATE,
    SUGGEST_PASSWORD,
    TOGGLE_SERVICE_SUBSCRIPTION_PERMISSION,
    UPDATE_FORM_TYPE,
    UPDATE_FORM_PREFIX
} from '@blocks/actions/form';

const formReducer = combineReducers({
    states,
    values,
    errors,
    validation,
    humanConfirmation,
    confirmationRetryCountdown(state = 30) {
        return state;
    },
    isEulaCheckedByDefault(state = true) {
        return state;
    },
    isPhoneCanBePrefilled(state = false) {
        return state;
    },
    isPhoneCallConfirmationAvailable(state = false) {
        return state;
    },
    isForcePhoneCallConfirmation(state = false) {
        return state;
    },
    isDiscardCallConfirmation(state = false) {
        return state;
    },
    isMobileRecallBtnRemoved(state = false) {
        return state;
    },
    isMobileCallConfirmationOnly(state = false) {
        return state;
    },
    isEulaShowedInPopup(state = false) {
        return state;
    },
    canSwitchConfirmationMethod(state = true) {
        return state;
    },
    keepUnsubscribedValue(state = false, action) {
        if (action.type === TOGGLE_SERVICE_SUBSCRIPTION_PERMISSION) {
            return action.isChecked;
        }

        return state;
    },
    keepUnsubscribedShown(state = false) {
        return state;
    },
    activeField(state = '', action) {
        if (action.type === CHANGE_ACTIVE_FIELD) {
            return action.field;
        }

        return state;
    },
    captchaRequired(state = false, action) {
        if (action.type === SET_CAPTCHA_REQUIRED) {
            return action.isRequired;
        }

        return state;
    },
    formErrors(state = []) {
        return state;
    },
    captchaErrors(state = []) {
        return state;
    },
    type(state = '', action) {
        if (action.type === UPDATE_FORM_TYPE) {
            return action.payload;
        }

        return state;
    },
    prefix(state = '', action) {
        if (action.type === UPDATE_FORM_PREFIX) {
            return action.payload;
        }

        return state;
    },

    isPasswordVisible(state = false, action = {}) {
        if (action.type === TOGGLE_PASSWORD_VISIBILITY_STATE) {
            return !state;
        }

        return state;
    },

    passwordWeight(state = '', action = {}) {
        if (action.type === SET_PASSWORD_WEIGHT) {
            const {payload = {}} = action;
            const {passwordWeight} = payload;

            return passwordWeight;
        }

        return state;
    },

    suggestedPassword(state = '', action = {}) {
        if (action.type === SUGGEST_PASSWORD) {
            const {payload = {}} = action;
            const {suggestedPassword} = payload;

            return suggestedPassword;
        }

        return state;
    }
});

export default formReducer;
