import {
    UPDATE_PHONE_CONFIRM_NUMBER,
    UPDATE_PHONE_CONFIRM_CODE,
    SET_PHONE_CONFIRM_ERRORS,
    SET_PHONE_CONFIRM_TIMER,
    CLEAR_SECURE_PHONE_NUMBER,
    SET_PHONE_CONFIRM_METHOD,
    SET_PHONE_CONFIRMATION_CALLING_NUMBER_TEMPLATE,
    SET_PHONE_CONFIRMATION_PHONE_CHECK_STATE,
    SET_PHONE_CONFIRMATION_DENY_RESEND_UNTIL,
    SET_PHONE_CONFIRMATION_INTERNATIONAL_PHONE_NUMBER,
    SET_PHONE_CODE_TIMER,
    SET_PREPARED_STORE,
    SET_CONFIRM_PROCESS_STATE,
    SET_IS_PASSWORD_REQUIRED,
    SET_CAPTCHA_REQUIRED
} from '@blocks/actions/phoneConfirm';

import {RESET_PHONE_BIND_CONFIRM} from '@blocks/Screens/PhoneBindConfirm/actions';

const initialState = {
    phoneNumber: '',
    internationalPhoneNumber: '',
    securePhoneNumber: '',
    errors: [],
    confirmationCode: '',
    isConfirmationCodeSent: false,
    isCaptchaRequired: false,
    phoneConfirmMethod: 'by_sms',
    denyResendUntil: '',
    callingNumberTemplate: '',
    shouldCheckPhone: false,
    isPasswordRequired: false
};

const phoneConfirm = (state = initialState, action = {}) => {
    const {type, payload = {}} = action;

    switch (type) {
        case SET_PREPARED_STORE:
        case SET_PHONE_CONFIRMATION_DENY_RESEND_UNTIL:
        case SET_PHONE_CODE_TIMER:
        case SET_PHONE_CONFIRM_METHOD:
        case SET_PHONE_CONFIRMATION_INTERNATIONAL_PHONE_NUMBER:
        case SET_PHONE_CONFIRMATION_CALLING_NUMBER_TEMPLATE:
        case SET_PHONE_CONFIRMATION_PHONE_CHECK_STATE:
        case SET_CONFIRM_PROCESS_STATE:
        case SET_IS_PASSWORD_REQUIRED:
        case SET_CAPTCHA_REQUIRED: {
            return Object.assign({}, state, payload);
        }

        case UPDATE_PHONE_CONFIRM_NUMBER: {
            const {phoneNumber} = payload;

            return Object.assign({}, state, {phoneNumber});
        }

        case UPDATE_PHONE_CONFIRM_CODE: {
            const {confirmationCode} = payload;

            return Object.assign({}, state, {confirmationCode});
        }

        case SET_PHONE_CONFIRM_ERRORS: {
            const {errors} = payload;

            return Object.assign({}, state, {errors});
        }

        case SET_PHONE_CONFIRM_TIMER: {
            return Object.assign({}, state, {
                denyResendUntil: Number(new Date()) + 30 * 1000
            });
        }

        case CLEAR_SECURE_PHONE_NUMBER: {
            return Object.assign({}, state, {
                securePhoneNumber: ''
            });
        }

        case RESET_PHONE_BIND_CONFIRM: {
            return Object.assign({}, state, {
                isConfirmationCodeSent: false
            });
        }

        default: {
            return state;
        }
    }
};

export default phoneConfirm;
