import {
    UPDATE_PHONE_PROCESS_INFO,
    SET_PHONE_PROCESS_CODE_SEND,
    SET_PHONE_PROCESS_CODE_CHECKED,
    SET_PHONE_PROCESS_TYPE,
    SET_PHONE_REPLACE_DONE,
    SET_PHONE_REPLACE_STARTED,
    TOGGLE_PHONE_UNAVAILABLE
} from '@blocks/actions/phone';

const initialState = {
    processType: '',
    isInProgress: false,
    isInQuarantine: false,
    isOldNumberUnAvailable: false,
    operationId: null,
    phoneId: null,
    hasCodeSent: false,
    hasCodeChecked: false,
    timer: 30
};

export default function phoneProcess(state = initialState, action) {
    switch (action.type) {
        case UPDATE_PHONE_PROCESS_INFO: {
            return Object.assign({}, state, action.payload);
        }
        case SET_PHONE_PROCESS_CODE_SEND: {
            return Object.assign({}, state, {
                hasCodeSent: true
            });
        }
        case SET_PHONE_PROCESS_CODE_CHECKED: {
            return Object.assign({}, state, {
                hasCodeChecked: true
            });
        }
        case SET_PHONE_PROCESS_TYPE: {
            return Object.assign({}, state, {
                processType: action.payload
            });
        }
        case SET_PHONE_REPLACE_STARTED: {
            return Object.assign({}, state, {
                phoneReplaceStatus: 'started'
            });
        }
        case SET_PHONE_REPLACE_DONE: {
            return Object.assign({}, state, {
                phoneReplaceStatus: 'done'
            });
        }
        case TOGGLE_PHONE_UNAVAILABLE: {
            return Object.assign({}, state, {
                isOldNumberUnAvailable: action.isOldNumberUnAvailable
            });
        }
        default:
            return state;
    }
}
