import {
    TOGGLE_PROFILE_PUBLIC_ACCESS,
    TOGGLE_PROFILE_PUBLIC_THIRD_PARTY_ACCESS,
    TOGGLE_PROFILE_PUBLIC_ACCESS_POPUP,
    PROFILE_PUBLIC_ACCESS_ERROR
} from '@blocks/actions/publicAccess';

export default function publicAccess(state = false, action) {
    switch (action.type) {
        case TOGGLE_PROFILE_PUBLIC_ACCESS: {
            return Object.assign({}, state, {
                hasPublicProfile: !state.hasPublicProfile
            });
        }
        case TOGGLE_PROFILE_PUBLIC_THIRD_PARTY_ACCESS: {
            return Object.assign({}, state, {
                hasThirdPartyAccess: !state.hasThirdPartyAccess
            });
        }
        case TOGGLE_PROFILE_PUBLIC_ACCESS_POPUP: {
            return Object.assign({}, state, {
                isPopupVisible: !state.isPopupVisible
            });
        }
        case PROFILE_PUBLIC_ACCESS_ERROR: {
            return Object.assign({}, state, {
                error: action.error
            });
        }
        default:
            return state;
    }
}
