import {
    SET_PUBLIC_ID_UPDATED,
    TOGGLE_PUBLIC_ID,
    SET_PUBLIC_ID_VALUE,
    SET_PUBLIC_ID_ENABLED,
    SET_PUBLIC_ID_SUGGEST,
    SET_PUBLIC_ID_SUGGEST_LOADING,
    UPDATE_NUMBER
} from '@blocks/actions/publicId';

export default function publicId(state = false, action) {
    switch (action.type) {
        case SET_PUBLIC_ID_UPDATED: {
            return Object.assign({}, state, {
                hasUpdated: action.hasUpdated
            });
        }
        case TOGGLE_PUBLIC_ID: {
            return Object.assign({}, state, {
                isOpened: action.isOpened
            });
        }
        case SET_PUBLIC_ID_VALUE: {
            return Object.assign({}, state, {
                id: action.value
            });
        }
        case SET_PUBLIC_ID_ENABLED: {
            return Object.assign({}, state, {hasPublicIdSet: true});
        }
        case SET_PUBLIC_ID_SUGGEST: {
            return Object.assign({}, state, {publicIdSuggest: action.publicIdSuggest});
        }
        case SET_PUBLIC_ID_SUGGEST_LOADING: {
            return Object.assign({}, state, {publicIdSuggestLoading: action.value});
        }
        case UPDATE_NUMBER: {
            return Object.assign({}, state, {
                updatesNumber: state.updatesNumber + 1
            });
        }
        default:
            return state;
    }
}
