import {UPDATE_TRACK_ID, DELETE_TRACK_ID} from '@blocks/actions/tracks';

const initialState = {};

const tracks = (store = initialState, action = {}) => {
    const {type, payload = {}} = action;

    switch (type) {
        case UPDATE_TRACK_ID: {
            const {type, id} = payload;

            return Object.assign({}, store, {[`${type}TrackId`]: id});
        }

        case DELETE_TRACK_ID: {
            const {type} = payload;

            return Object.assign({}, store, {[`${type}TrackId`]: undefined});
        }

        default: {
            return store;
        }
    }
};

export default tracks;
