import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {eulaContent} from '../../registration/desktop/eula/EulaPopup.jsx';
import registerAccount from '../methods/registerAccount';
import classnames from 'classnames';

export default class EulaBlock extends Component {
    constructor(props) {
        super(props);
        this.sendRegData = this.sendRegData.bind(this);
    }

    sendRegData() {
        this.props.dispatch(registerAccount());
    }

    render() {
        const {isMobile} = this.props;

        return (
            <div
                className={classnames('registration__form', {registration__form_desktop: !isMobile}, 'lite-experiment')}
            >
                {eulaContent(false, i18n('_AUTH_.money.acceptance.common'), this.sendRegData, 'm', true)}
            </div>
        );
    }
}

EulaBlock.propTypes = {
    dispatch: PropTypes.func.isRequired,
    isMobile: PropTypes.bool.isRequired
};
