import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import RegistrationEmailInput from './RegistrationEmailInput.jsx';
import {updateValues} from '@blocks/actions/form';
import RegistrationNameInput from '@blocks/registration/fieldComponents/name/name_input.jsx';
import RegistrationSurnameInput from '@blocks/registration/fieldComponents/surname/surname_input.jsx';
import UserPassword from '@blocks/registration/fieldComponents/userpassword.jsx';
import {Button} from '@components/Button';

export const PasswordControls = (props) => {
    const {isPasswordStepVisible, states, values, errors, isMobile, dispatch} = props;

    if (isPasswordStepVisible) {
        return (
            <UserPassword
                isMobile={isMobile}
                isLiteReg={true}
                isAutoFocusEnabled={true}
                states={states}
                values={values}
                errors={errors}
                dispatch={dispatch}
            />
        );
    }
    return null;
};

PasswordControls.propTypes = {
    isPasswordStepVisible: PropTypes.bool.isRequired,
    states: PropTypes.object.isRequired,
    values: PropTypes.object.isRequired,
    errors: PropTypes.object.isRequired,
    dispatch: PropTypes.func.isRequired,
    isMobile: PropTypes.bool
};

export const NameControls = (props) => {
    const {isPasswordStepVisible, form, isAutoFocuseDisabled, updateFieldValue, isMobile, dispatch} = props;
    const {states, values, errors, activeField} = form;

    if (!isPasswordStepVisible) {
        return (
            <div>
                <RegistrationEmailInput isAutoFocuseDisabled={false} updateUserField={updateFieldValue} />
                <RegistrationNameInput
                    dispatch={dispatch}
                    isMobile={isMobile}
                    value={values.firstname}
                    state={states.firstname}
                    activeError={errors.active}
                    error={errors.firstname}
                    isAutoFocuseDisabled={isAutoFocuseDisabled}
                    activeField={activeField}
                    updateUserField={updateFieldValue}
                />
                <RegistrationSurnameInput
                    dispatch={dispatch}
                    isMobile={isMobile}
                    value={values.lastname}
                    state={states.lastname}
                    activeError={errors.active}
                    error={errors.lastname}
                    hintActive={errors.hintActive}
                    activeField={activeField}
                    updateUserField={updateFieldValue}
                />
            </div>
        );
    }
    return null;
};

NameControls.propTypes = {
    isPasswordStepVisible: PropTypes.bool.isRequired,
    form: PropTypes.object.isRequired,
    isAutoFocuseDisabled: PropTypes.bool,
    isMobile: PropTypes.bool,
    updateFieldValue: PropTypes.func.isRequired,
    dispatch: PropTypes.func.isRequired
};

export class RegistrationFields extends PureComponent {
    static mapStateToProps(state) {
        const {form} = state;

        return {
            form
        };
    }

    constructor(props) {
        super(props);

        this.updateFieldValue = this.updateFieldValue.bind(this);
    }

    updateFieldValue(value, field) {
        const {dispatch} = this.props;
        const fieldInfo = {
            field: field.name,
            value
        };

        dispatch(updateValues(fieldInfo));
    }

    render() {
        const {form, isPasswordStepVisible, showPasswordFields, isMobile, dispatch} = this.props;
        const {states, values, errors} = form;

        return (
            <div>
                <NameControls
                    isMobile={isMobile}
                    isPasswordStepVisible={isPasswordStepVisible}
                    form={form}
                    isAutoFocuseDisabled={true}
                    updateFieldValue={this.updateFieldValue}
                    dispatch={dispatch}
                />
                <PasswordControls
                    isMobile={isMobile}
                    isPasswordStepVisible={isPasswordStepVisible}
                    states={states}
                    values={values}
                    errors={errors}
                    dispatch={dispatch}
                />

                {!isPasswordStepVisible && (
                    <div data-t='registration-lite:btn-next'>
                        <Button view='action' size='l' width='max' onClick={showPasswordFields}>
                            {i18n('_AUTH_.next_registration_step')}
                        </Button>
                    </div>
                )}
            </div>
        );
    }
}

export default connect(RegistrationFields.mapStateToProps)(RegistrationFields);

RegistrationFields.propTypes = {
    form: PropTypes.object.isRequired,
    isPasswordStepVisible: PropTypes.bool,
    showPasswordFields: PropTypes.func,
    dispatch: PropTypes.func.isRequired,
    isMobile: PropTypes.bool
};
