import api from '@blocks/api';
import {updateRegistrationErrors, updateFetchingStatus, showEulaPopup} from '@blocks/registration/actions';
import {updateStates} from '@blocks/actions/form';
import metrics from '@blocks/metrics';
import {errorsTxt} from '@blocks/registration-lite/errors';
import {handleRegistrationError} from './registrationLiteMethods';

const globalRegistrationError = {
    status: 'error',
    code: 'global',
    text: errorsTxt.global.errors.global
};

export default function() {
    return (dispatch, getState) => {
        const state = getState();
        const {form, settings, common, registrationType} = state;
        const {values} = form;
        const {language} = settings;
        const baseRedirectUrl = `/registration/finish?track_id=${common.track_id}`;
        const baseData = {
            track_id: common.track_id,
            language,
            login: values.email,
            password: values.password,
            eula_accepted: true,
            registrationType
        };
        const formData = Object.assign({}, baseData, values);

        dispatch(updateFetchingStatus(true));
        return api
            .request('registration-lite-experiment.commit', formData)
            .then((response) => {
                if (response.status === 'ok') {
                    metrics.send(['Форма', 'Успешная lite-регистрация']);
                    window.location.href = baseRedirectUrl;
                } else {
                    dispatch(updateFetchingStatus(false));
                    dispatch(updateRegistrationErrors(globalRegistrationError));
                }
            })
            .fail((error) => {
                dispatch(updateFetchingStatus(false));
                dispatch(updateStates({field: 'emailCodeStatus', status: ''}));
                dispatch(showEulaPopup(false));
                metrics.send(['Отправка формы', `Ошибка lite-регистрации: ${error}`]);
                handleRegistrationError(error, dispatch, state.common.currentPage);
            });
    };
}
