import scrollToError from '@blocks/registration/methods/scrollToError';
import metrics from '@blocks/metrics';
import {setCurrentStep} from '@blocks/registration/actions';
import {updateErrorStates, updateGroupErrors} from '@blocks/actions/form';
import sendConfirmationCode from './sendConfirmationCode';
import {errorsTxt as commonErrorsTxt} from '@blocks/registration/errors';
import {errorsTxt} from '@blocks/registration-lite/errors';

const allErrorTexts = Object.assign({}, commonErrorsTxt, errorsTxt);
const isPasswordWarning = (field, passwordError) => {
    if (field === 'password' && passwordError.warning) {
        return true;
    }
    return false;
};

export default function() {
    return (dispatch, getState) => {
        const state = getState();
        const {form} = state;
        const {states, errors} = form;
        const statesToRemove = (item) => item !== 'captcha' && item !== 'emailCode' && item !== 'emailCodeStatus';
        const statesToCheck = [];

        for (const key in states) {
            if (states.hasOwnProperty(key) && statesToRemove(key)) {
                statesToCheck.push(key);
            }
        }
        const invalidFields = statesToCheck.filter(
            (item) => states[item] !== 'valid' && !isPasswordWarning(item, errors.password)
        );
        const isFormInvalid = invalidFields.length > 0;

        if (isFormInvalid) {
            moveToPrevStep(invalidFields, dispatch);
            setFormErrors(errors, invalidFields, dispatch);
            return;
        }
        dispatch(sendConfirmationCode());
    };
}

function setFormErrors(errors, invalidFields, dispatch) {
    const invalidFieldsObj = invalidFields.reduce((obj, d) => Object.assign(obj, {[d]: 'not_valid'}), {});
    const firstFieldWithError = invalidFields[0];
    const errorFields = invalidFields.reduce((previousValue, currentValue) => {
        const errorCode = errors[currentValue].code || 'missingvalue';
        const objWithError = {
            code: errorCode,
            text: allErrorTexts[currentValue].errors[errorCode]
        };

        return Object.assign(previousValue, {[currentValue]: objWithError});
    }, {});
    const errorDOMElem = document.querySelector(`#${firstFieldWithError}`);

    dispatch(updateErrorStates(invalidFieldsObj));
    dispatch(updateGroupErrors(Object.assign({}, {active: firstFieldWithError}, errorFields)));

    if (errorDOMElem) {
        scrollToError(errorDOMElem);
    }
    metrics.send(['Форма', `Показ ошибок, неправильно заполнены поля ${Object.keys(invalidFieldsObj)}`]);
    metrics.goal('lite_experiment_form_invalid');
}

export function moveToPrevStep(invalidFields, dispatch) {
    const firstFieldError = invalidFields[0];
    const fieldsFromFirstStep = ['email', 'firstname', 'lastname'];

    if (fieldsFromFirstStep.includes(firstFieldError)) {
        dispatch(setCurrentStep('start'));
    }
}
