import {combineReducers} from 'redux';
import common from '@blocks/common/reducers';
import captcha from '@components/Captcha/reducers';
import fetchingStatus from '@blocks/registration/reducers/fetchingStatus';
import registrationErrors from '@blocks/registration/reducers/registrationErrors';
import registrationStep from '@blocks/registration/reducers/registrationStep';
import validation from '@blocks/reducers/form/formValidation';
import states from '@blocks/reducers/form/formStates';
import values from '@blocks/reducers/form/formValues';
import errors from '@blocks/reducers/form/formErrors';
import {CHANGE_ACTIVE_FIELD} from '@blocks/actions/form';
import {UPDATE_FORM_HEADER} from './actions';
import tracks from '@blocks/reducers/tracks';

const formReducer = combineReducers({
    settings(state = {}) {
        return state;
    },
    footer(state = {langlist: []}) {
        return state;
    },
    common,
    captcha,
    fetchingStatus,
    registrationErrors,
    registrationStep,
    form: combineReducers({
        states,
        values,
        errors,
        validation,
        activeField(state = '', action) {
            if (action.type === CHANGE_ACTIVE_FIELD) {
                return action.field;
            }

            return state;
        },
        formErrors(state = []) {
            return state;
        },
        type(state = '') {
            return state;
        },
        prefix(state = '') {
            return state;
        }
    }),
    metrics(state = {}) {
        return state;
    },
    formHeader(state = {title: i18n('Frontend.registration_main-title')}, action) {
        if (action.type === UPDATE_FORM_HEADER) {
            return {
                title: action.title
            };
        }
        return state;
    },
    monitoring(state = {page: 'registration'}) {
        return state;
    },
    registrationType(state = 'lite') {
        return state;
    },
    registrationName(state = 'lite') {
        return state;
    },
    tracks
});

export default formReducer;
