export const UPDATE_FETCHING_STATUS = 'UPDATE_FETCHING_STATUS';
export const GET_SUGGESTED_LOGINS = 'GET_SUGGESTED_LOGINS';
export const UPDATE_REG_ERROR = 'UPDATE_REG_ERROR';
export const SET_CURRENT_STEP = 'SET_CURRENT_STEP';
export const REGISTRATION_GOAL_PREFIX = 'registration';
export const REGISTRATION_COMPLETE_GOAL_PREFIX = 'complete_v2';
export const REGISTRATION_COMPLETE_MOBILE_GOAL_PREFIX = 'complete_v2_mobile';
export const REGISTRATION_PDD_GOAL_PREFIX = 'registration_pdd';
export const REGISTRATION_PDD_MOBILE_GOAL_PREFIX = 'registration_pdd_mobile';
export const REGISTRATION_MOBILE_GOAL_PREFIX = 'registration_mobile';
export const REGISTRATION_MOBILE_OS_GOAL_PREFIX = 'registration_mobile_os';
export const SET_SUGGESTION_VALIDATING_STATUS = 'SET_SUGGESTION_VALIDATING_STATUS';
export const CLEAR_SUGGESTED_LOGINS = 'CLEAR_SUGGESTED_LOGINS';
export const SHOW_EULA_POPUP = 'SHOW_EULA_POPUP';
export const TOGGLE_PHONE_CONFIRMATION = 'TOGGLE_PHONE_CONFIRMATION';

export const UPDATE_PHONE_HINT_STATUS = 'UPDATE_PHONE_HINT_STATUS';
export const UPDATE_PHONE_HINT_TEXT = 'UPDATE_PHONE_HINT_TEXT';
export const UPDATE_PHONE_CODE_HINT_TEXT = 'UPDATE_PHONE_CODE_HINT_TEXT';
export const UPDATE_PHONE_CODE_STATUS = 'UPDATE_PHONE_CODE_STATUS';
export const UPDATE_PHONE_CODE_STATUS_AGAIN = 'UPDATE_PHONE_CODE_STATUS_AGAIN';
export const UPDATE_PHONE_CODE_HINT_STATUS = 'UPDATE_PHONE_CODE_HINT_STATUS';
export const UPDATE_PHONE_CONFIRMATION_CALL_NUMBER = 'UPDATE_PHONE_CONFIRMATION_CALL_NUMBER';

export const SEND_SMS_METRIC_PARAM = 'Отправка кода';
export const SEND_SMS_AGAIN_METRIC_PARAM = 'Повторная отправка кода';
export const MAKE_CALL_METRIC_PARAM = 'Звонок';
export const MAKE_CALL_AGAIN_METRIC_PARAM = 'Повторный звонок';
export const MAGIC_CALL_CONFIRMATION_METRIC_PARAM = 'Подтверждение телефона через звонок с магией';
export const DICTATION_CALL_CONFIRMATION_METRIC_PARAM = 'Подтверждение телефона через звонок';
export const SMS_CONFIRMATION_METRIC_PARAM = 'Подтверждение телефона';
export const SUCCESS_CONFIRMATION_CALL_METRIC_PARAM = 'Успешное подтверждение через звонок';
export const SUCCESS_CONFIRMATION_SMS_METRIC_PARAM = 'Успешное подтверждение через смс';
export const DISCARD_CALL_CONFIRMATION_METRIC_PARAM = 'Подтверждение телефона через прерывание звонка';

export function clearSuggestedLogins() {
    return {
        type: CLEAR_SUGGESTED_LOGINS
    };
}

export function setSuggestionFetching(isValidating) {
    return {
        type: SET_SUGGESTION_VALIDATING_STATUS,
        isValidating
    };
}

export function updateRegistrationErrors(data) {
    return {
        type: UPDATE_REG_ERROR,
        data
    };
}

export function updateFetchingStatus(isFetching) {
    return {
        type: UPDATE_FETCHING_STATUS,
        isFetching
    };
}

export function updateSuggestedLogins(data) {
    return {
        type: GET_SUGGESTED_LOGINS,
        data
    };
}

export function setCurrentStep(step) {
    return {
        type: SET_CURRENT_STEP,
        step
    };
}

export function showEulaPopup(isPopupShowing) {
    return {
        type: SHOW_EULA_POPUP,
        isPopupShowing
    };
}

export function togglePhoneConfirmationPopup(isPhoneConfirmationOpened) {
    return {
        type: TOGGLE_PHONE_CONFIRMATION,
        isPhoneConfirmationOpened
    };
}

export function updatePhoneHintStatus(isShown) {
    return {
        type: UPDATE_PHONE_HINT_STATUS,
        isShown
    };
}

export function updatePhoneCodeHintStatus(isShown) {
    return {
        type: UPDATE_PHONE_CODE_HINT_STATUS,
        isShown
    };
}

export function updatePhoneHintText(text) {
    return {
        type: UPDATE_PHONE_HINT_TEXT,
        text
    };
}

export function updatePhoneCodeHintText(hint) {
    return {
        type: UPDATE_PHONE_CODE_HINT_TEXT,
        hint
    };
}

export function updatePhoneCodeSend(status) {
    return {
        type: UPDATE_PHONE_CODE_STATUS,
        status
    };
}

export function updatePhoneCodeSendAgain(status) {
    return {
        type: UPDATE_PHONE_CODE_STATUS_AGAIN,
        status
    };
}

export function updatePhoneConfirmationCallNumber(maskedPhoneNumberStr) {
    return {
        type: UPDATE_PHONE_CONFIRMATION_CALL_NUMBER,
        maskedPhoneNumberStr
    };
}
