import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Button} from '@components/Button';
import {UniversalTile} from '@components/UniversalTile';
import {ChildishIcon} from './Icons/ChildishIcon';
import './ChildishRegLanding.styl';

const b = cn('ChildishRegLanding');
const dataT = 'reg:childish:landing';

const OPTIONS = [
    {
        title: i18n('_AUTH_.childish-reg-landing.option.1.title'),
        description: i18n('_AUTH_.childish-reg-landing.option.1.description'),
        icon: 'manage'
    },
    {
        title: i18n('_AUTH_.childish-reg-landing.option.2.title'),
        description: i18n('_AUTH_.childish-reg-landing.option.2.description'),
        icon: 'filter'
    },
    {
        title: i18n('_AUTH_.childish-reg-landing.option.3.title'),
        description: i18n('_AUTH_.childish-reg-landing.option.3.description'),
        icon: 'control'
    },
    {
        title: i18n('_AUTH_.childish-reg-landing.option.4.title'),
        description: i18n('_AUTH_.childish-reg-landing.option.4.description'),
        icon: 'family'
    }
];

export class ChildishRegLanding extends React.Component {
    onNextButtonClick = () => {
        const {onNextButtonClick} = this.props;

        onNextButtonClick && onNextButtonClick();
    };

    renderOptionsItems = () =>
        OPTIONS.map((item, i) => (
            <div className={b('optionsItem')} key={i}>
                <UniversalTile
                    type='block'
                    leftComponent={<div className={b('optionsIcon', {icon: item.icon})} />}
                    title={item.title}
                    description={item.description}
                    verticalAlignCenter={true}
                />
            </div>
        ));

    render() {
        const {showTitle = true} = this.props;

        return (
            <div className={b()} data-t={dataT}>
                <div className={b('wrapper')}>
                    {showTitle && <div className={b('title')}>{i18n('_AUTH_.childish-reg-landing.title')}</div>}
                    <div className={b('description')}>{i18n('_AUTH_.childish-reg-landing.description')}</div>
                    <div className={b('optionsList')}>{this.renderOptionsItems()}</div>
                    <Button
                        width='max'
                        type={'button'}
                        view={'action'}
                        size='l'
                        onClick={this.onNextButtonClick}
                        data-t={`${dataT}:button:next`}
                        text={i18n('_AUTH_.childish-reg-landing.btn.next')}
                    />

                    <a className={b('bottomLink')}>
                        <div className={b('bottomLinkIcon')}>
                            <ChildishIcon />
                        </div>
                        <div className={b('bottomLinkText')}>{i18n('_AUTH_.childish-reg-landing.link.text')}</div>
                    </a>
                </div>
            </div>
        );
    }
}

ChildishRegLanding.propTypes = {
    onNextButtonClick: PropTypes.function,
    showTitle: PropTypes.bool
};
