import React from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import classnames from 'classnames';
import {promoTexts} from './customization';

const CustomIcons = ({origin, staticPath, customOrigin}) => {
    const icons = customOrigin ? promoTexts[customOrigin].icons : promoTexts[origin].icons || [];

    return (
        <ul className={`services__icons services__icons-${customOrigin || origin}`}>
            {icons.map((icon) => (
                <li className={classnames(`service__icon ${icon}`)} key={icon}>
                    <img src={`${staticPath}/i/services_icons/customization/${icon}.png`} role='presentation' />
                </li>
            ))}
        </ul>
    );
};

function mapStateToProps(state) {
    const {
        settings: {origin, staticPath}
    } = state;

    return {
        origin,
        staticPath
    };
}

export default connect(mapStateToProps)(CustomIcons);

CustomIcons.propTypes = {
    origin: PropTypes.string.isRequired,
    customOrigin: PropTypes.string,
    staticPath: PropTypes.string.isRequired
};
