import React from 'react';
import PropTypes from 'prop-types';
import {Logo as YandexLogo} from '@components/Logo';

const Logo = ({origin, staticPath}) => {
    const isDefaultLogo = ['default', 'appmetrica', 'practicum', 'praktikum'].includes(origin);

    return isDefaultLogo ? (
        <div className='yaLogo-wrap'>
            <YandexLogo size='l' isStatic={true} className='yaLogo' />
        </div>
    ) : (
        <div className={`${origin}-logo`}>
            <img src={`${staticPath}/i/services_icons/customization/${origin}-logo.png`} />
        </div>
    );
};

Logo.propTypes = {
    origin: PropTypes.string.isRequired,
    staticPath: PropTypes.string.isRequired
};

export default Logo;
