export const knownOrigins = ['default', 'appmetrica', 'education'];
export const knownOriginsMobile = ['default', 'appmetrica'];
export const promoTexts = {
    default: {
        title: i18n('Frontend.registration_main-title'),
        newLogoTitle: i18n('Frontend.registration_main-title_id'),
        descr: i18n('Frontend.registration_main-description')
    },
    defaultAlternative: {
        title: i18n('Frontend.registration_main-title'),
        descr: i18n('Frontend.registration_alternative-description')
    },
    appmetrica: {
        title: i18n('Frontend.registration.promo.appmetrica.title'),
        descr: i18n('Frontend.registration.promo.appmetrica.desc')
    },
    education: {
        title: i18n('Frontend.registration.promo.textbook.title_update'),
        descr: i18n('Frontend.registration.promo.textbook.desc_update'),
        icons: ['icon1', 'icon2', 'icon3', 'icon4']
    },
    practicum: {
        title: i18n('Frontend.registration.promo.practicum.title'),
        descr: i18n('Frontend.registration.promo.practicum.desc'),
        icons: ['practicum']
    },
    praktikum: {
        title: i18n('Frontend.registration.promo.practicum.title'),
        descr: i18n('Frontend.registration.promo.practicum.desc'),
        icons: ['practicum']
    },
    plusPromo: {
        title: i18n('Frontend.registration_main-title'),
        descr: i18n('Plus.registration.promo.description'),
        icons: ['plus-mail', 'plus-disk', 'plus-kinopoisk', 'plus-music']
    }
};

export function getTextAccordingToTldOrOrigin(tld, origin, isPlusPromo) {
    if ((origin === 'practicum' || origin === 'praktikum') && tld === 'com') {
        knownOrigins.push(origin);
        knownOriginsMobile.push(origin);
    }

    const originVal = knownOrigins.includes(origin) ? origin : 'default';
    const tldsWithAlternativeTexts = ['com', 'com.tr', 'fr', 'ee', 'lv', 'lt', 'com.am', 'com.ge', 'com.am'];

    let promoTextObj = promoTexts.default;

    if (originVal !== 'default') {
        promoTextObj = promoTexts[origin];
    }

    if (tldsWithAlternativeTexts.includes(tld) && originVal === 'default') {
        promoTextObj = promoTexts.defaultAlternative;
    }

    if (isPlusPromo) {
        promoTextObj = promoTexts.plusPromo;
    }

    return promoTextObj;
}
