import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import classnames from 'classnames';

class FieldPopup extends PureComponent {
    static mapStateToProps(state) {
        const {
            form,
            settings: {uatraits}
        } = state;
        const activeField = form.errors.active;
        const hintActive = form.errors.hintActive;
        const isMobile = uatraits.isMobile && !uatraits.isTablet;

        return {
            activeField,
            hintActive,
            isMobile
        };
    }

    render() {
        const {activeField, fieldName, children, visible, isMobile} = this.props;

        if (visible || activeField === fieldName) {
            return (
                <div
                    className={classnames({
                        'reg-field__popup': !isMobile,
                        'reg-field__descr': isMobile
                    })}
                    aria-live='polite'
                >
                    {children}
                </div>
            );
        }
        return null;
    }
}

FieldPopup.defaultProps = {
    visible: false,
    activeField: ''
};

FieldPopup.propTypes = {
    visible: PropTypes.bool,
    activeField: PropTypes.string,
    fieldName: PropTypes.string,
    isMobile: PropTypes.bool,
    children: PropTypes.oneOfType([PropTypes.string, PropTypes.element, PropTypes.bool])
};

export default connect(FieldPopup.mapStateToProps)(FieldPopup);
