import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Checkbox} from '@components/Checkbox';
import {ServiceSubscriptionPermission} from '@components/ServiceSubscripionPermission';

const EulaStandardText = (props) => (
    <div className='form__eula'>
        <Checkbox
            size='m'
            id='eula_accepted'
            name='eula_accepted'
            checked={props.eulaChecked}
            onChange={props.handleChange}
            dangerouslyLabel={
                props.isChildishReg ? i18n('_AUTH_.money.acceptance.childish') : i18n('_AUTH_.money.acceptance.common')
            }
        />
    </div>
);

EulaStandardText.propTypes = {
    eulaChecked: PropTypes.bool.isRequired,
    handleChange: PropTypes.func.isRequired,
    isChildishReg: PropTypes.bool
};

const EulaMoneyText = (props) =>
    props.validationMethod === 'phone' && (
        <div className='form__eula form__eula_money'>
            <Checkbox
                size='m'
                id='money_eula_accepted'
                name='money_eula_accepted'
                checked={props.eulaMoneyChecked}
                onChange={props.handleChange}
            >
                <span dangerouslySetInnerHTML={{__html: i18n('EULA.money.acceptance.money')}} />
            </Checkbox>
        </div>
    );

EulaMoneyText.propTypes = {
    eulaMoneyChecked: PropTypes.bool.isRequired,
    validationMethod: PropTypes.string.isRequired,
    handleChange: PropTypes.func.isRequired
};

class Eula extends Component {
    constructor(props) {
        super(props);
        const {isEulaCheckedByDefault} = this.props;

        this.state = {
            eulaChecked: isEulaCheckedByDefault
        };
    }

    render() {
        const {eulaChecked, handleEula, isChildishReg} = this.props;

        return (
            <div data-t='eula-block'>
                <div className='form__eula'>
                    <span dangerouslySetInnerHTML={{__html: i18n('EULA.money.acceptance.title')}} />
                </div>

                <EulaStandardText eulaChecked={eulaChecked} handleChange={handleEula} isChildishReg={isChildishReg} />
                <ServiceSubscriptionPermission />
            </div>
        );
    }
}

export default Eula;

Eula.propTypes = {
    validationMethod: PropTypes.string,
    eulaChecked: PropTypes.bool.isRequired,
    handleEula: PropTypes.func,
    isEulaCheckedByDefault: PropTypes.bool,
    isChildishReg: PropTypes.bool
};
