import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import classnames from 'classnames';
import {Button} from '@components/Button';
import {showEulaPopup} from '../../actions';
import {ServiceSubscriptionPermission} from '@components/ServiceSubscripionPermission';

export const eulaContent = (text, sendRegistrationData, size, showSubscrCheckbox) => (
    <div className='t-eula-accept'>
        <h3>{i18n('_AUTH_.acceptance.popup.title')}</h3>
        <div className='eula-popup__text'>
            <p dangerouslySetInnerHTML={{__html: text}} />
        </div>
        {showSubscrCheckbox && <ServiceSubscriptionPermission />}
        <Button view='action' size={size || 'l'} width='max' onClick={sendRegistrationData}>
            {i18n('_AUTH_.accept.button')}
        </Button>
    </div>
);

export class EulaPopup extends Component {
    constructor(props) {
        super(props);

        this.close = this.close.bind(this);
        this.sendRegistrationData = this.sendRegistrationData.bind(this);
        this.returnEulaText = this.returnEulaText.bind(this);
    }

    static mapStateToProps(state) {
        const {isEulaConfirmPopupShow, settings, form} = state;
        const {uatraits} = settings;
        const isMobile = uatraits.isMobile && !uatraits.isTablet;
        const {method} = form.validation;
        const isPDDRegistration = form.prefix === 'registration_pdd' || form.prefix === 'registration_pdd_mobile';

        return {
            isMobile,
            isEulaConfirmPopupShow,
            method,
            isPDDRegistration
        };
    }

    static eulaText(isPDDRegistration, text) {
        if (text) {
            return text;
        }

        if (isPDDRegistration) {
            return i18n('EULA.acceptance.workspace');
        }
        return i18n('_AUTH_.money.acceptance.common');
    }

    close() {
        this.props.dispatch(showEulaPopup(false));
    }

    sendRegistrationData() {
        const {sendData} = this.props;

        this.close();
        sendData();
    }

    returnEulaText() {
        const {isPDDRegistration, text} = this.props;

        if (text) {
            return text;
        }

        if (isPDDRegistration) {
            return i18n('EULA.acceptance.workspace');
        }

        return i18n('_AUTH_.money.acceptance.common');
    }

    render() {
        const {isMobile, isEulaConfirmPopupShow, isPDDRegistration, text, showSubscrCheckbox} = this.props;
        const eulaText = EulaPopup.eulaText(isPDDRegistration, text);
        const buttonSize = isMobile ? 'l' : 'm';

        return (
            <div
                className={classnames('eula-popup-wrapper', {
                    'eula-popup-mobile': isMobile,
                    'eula-popup__show': isEulaConfirmPopupShow
                })}
            >
                <div className='p-control-modal-close' onClick={this.close} />
                <div className='eula-popup'>
                    {eulaContent(eulaText, this.sendRegistrationData, buttonSize, showSubscrCheckbox)}
                </div>
            </div>
        );
    }
}

export default connect(EulaPopup.mapStateToProps)(EulaPopup);

EulaPopup.propTypes = {
    isMobile: PropTypes.bool.isRequired,
    isEulaConfirmPopupShow: PropTypes.bool.isRequired,
    sendData: PropTypes.func.isRequired,
    method: PropTypes.string,
    text: PropTypes.string,
    isPDDRegistration: PropTypes.bool,
    showSubscrCheckbox: PropTypes.bool,
    dispatch: PropTypes.func
};
