import React, {Component} from 'react';
import PropTypes from 'prop-types';

import {errorsTxt} from '../../errors';

class FormErrors extends Component {
    render() {
        if (!this.props.errors.length) {
            return null;
        }

        return (
            <div role='alert'>
                {this.props.errors.map(({field, code}) => (
                    <div key={`${field}.${code}`} className='error-message'>
                        {errorsTxt[field]
                            ? errorsTxt[field].errors[code] || errorsTxt[field].errors[`${field}.${code}`]
                            : errorsTxt.global.errors.global}
                    </div>
                ))}
            </div>
        );
    }
}

FormErrors.propTypes = {
    errors: PropTypes.array.isRequired
};

export default FormErrors;
