export const TLD_TO_SKIP_PROMO = ['pl', 'lt', 'lv', 'ee', 'fi'];

export default function mapStateToProps(state) {
    const {common, settings, registrationErrors, registrationType, form, footer, isIconsExperiment} = state;
    const {uatraits, tld, language} = settings;
    const isMobile = uatraits.isMobile && !uatraits.isTablet;
    const {isPhoneCallConfirmationAvailable, isForcePhoneCallConfirmation, isDiscardCallConfirmation} = form;
    const isResetCallExperiment =
        isPhoneCallConfirmationAvailable && (isForcePhoneCallConfirmation || isDiscardCallConfirmation);
    const skipPromo = TLD_TO_SKIP_PROMO.includes(tld);

    return {
        tld,
        skipPromo,
        language,
        isMobile,
        footer,
        common,
        settings,
        registrationErrors,
        isResetCallExperiment,
        registrationType,
        isIconsExperiment
    };
}
