import React, {Fragment, Component} from 'react';
import PropTypes from 'prop-types';
import CustomIcons from '@blocks/registration/customizations/CustomIcons.jsx';
import Logo from '@blocks/registration/customizations/Logo.jsx';
import SpinnerComponent from '@blocks/registration/spinner/spinner.jsx';
import Footer from '@components/Footer/Footer.jsx';
import ServicesIcons from './ServiceIcons.jsx';
import {PlusPromoSlogan} from '@blocks/registration/customizations/PlusPromo/PlusPromoSlogan';
import {getTextAccordingToTldOrOrigin} from '@blocks/registration/customizations/customization';
import mapStateToProps from './mapStateToProps';
import {connect} from 'react-redux';

class Promo extends Component {
    renderPromoIcons = () => {
        const {tld, origin, isPlusPromo, resultOrigin, browserName, staticPath} = this.props;
        const servicesList = this.defineSevicesIcons();
        const isOriginToCustomize =
            origin === 'education' || ((origin === 'practicum' || origin === 'praktikum') && tld === 'com');

        if (isOriginToCustomize || isPlusPromo) {
            return <CustomIcons customOrigin={isPlusPromo ? 'plusPromo' : ''} />;
        }

        return (
            <ServicesIcons
                origin={resultOrigin}
                tld={tld}
                servicesList={servicesList}
                browserName={browserName}
                staticPath={staticPath}
            />
        );
    };

    defineSevicesIcons = () => {
        const tld = this.props.tld;
        const isCom = ['com', 'com.tr', 'fr', 'ee', 'lv', 'lt', 'com.am', 'com.ge', 'com.am'].includes(tld);
        const isUa = ['ua', 'kz', 'by', 'uz', 'tm', 'tj', 'md', 'kg', 'co.il', 'az'].includes(tld);
        const servicesList = {
            isCom: ['maps', 'browser', 'translate', 'mail', 'disk'],
            isUa: ['maps', 'mail', 'disk', 'market', 'music'],
            isRu: ['mail', 'disk', 'market', 'music']
        };

        if (isCom) {
            return servicesList.isCom;
        }

        if (isUa) {
            return servicesList.isUa;
        }

        return servicesList.isRu;
    };

    render() {
        const {isMobile, staticPath, tld, origin, resultOrigin, isPlusPromo, skipPromo, fetchingStatus} = this.props;
        const text = getTextAccordingToTldOrOrigin(tld, origin, isPlusPromo);

        if (isMobile) {
            return null;
        }

        return (
            <Fragment>
                {skipPromo ? (
                    <Footer page='registration_simple' />
                ) : (
                    <aside className='presentation' role='presentation'>
                        <div className='presentation__wrapper'>
                            <Logo origin={resultOrigin} staticPath={staticPath} />
                            <h2 className='description__text'>
                                {resultOrigin === 'default' ? text.newLogoTitle : text.title}
                            </h2>
                            {this.renderPromoIcons()}
                            <div className='presentation__about' dangerouslySetInnerHTML={{__html: text.descr}} />
                            {isPlusPromo && <PlusPromoSlogan />}
                            <SpinnerComponent fetchingStatus={fetchingStatus} />
                        </div>
                        <Footer page='registration' />
                    </aside>
                )}
            </Fragment>
        );
    }
}

Promo.propTypes = {
    origin: PropTypes.string,
    resultOrigin: PropTypes.string,
    tld: PropTypes.string.isRequired,
    servicesList: PropTypes.array,
    browserName: PropTypes.string,
    staticPath: PropTypes.string,
    isMobile: PropTypes.bool,
    fetchingStatus: PropTypes.bool,
    skipPromo: PropTypes.bool,
    isPlusPromo: PropTypes.bool
};

export default connect(mapStateToProps)(Promo);
