import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

const ServicesIcons = ({origin, tld, servicesList, browserName, staticPath}) => (
    <ul
        className={classnames('services__icons', {
            'services__icons-animate': tld === 'ru'
        })}
    >
        {servicesList.map((service, index) => {
            let resultService = service;

            if (origin !== 'default' && service === 'disk') {
                resultService = origin;
            }
            return (
                <li
                    className={classnames(`service__icon icon-${resultService}`, {
                        'icon-scale': resultService === origin
                    })}
                    key={index}
                >
                    <ServiceIcon browserName={browserName} staticPath={staticPath} service={resultService} />
                </li>
            );
        })}
    </ul>
);

ServicesIcons.propTypes = {
    servicesList: PropTypes.array.isRequired,
    origin: PropTypes.string,
    tld: PropTypes.string.isRequired,
    browserName: PropTypes.string,
    staticPath: PropTypes.string.isRequired
};

const ServiceIcon = ({staticPath, service, browserName}) => {
    const type = ['MSIE', 'Edge'].indexOf(browserName) !== -1 ? 'png' : 'svg';

    return <img src={`${staticPath}/i/services_icons/${service}.${type}`} role='presentation' />;
};

ServiceIcon.propTypes = {
    service: PropTypes.string.isRequired,
    staticPath: PropTypes.string.isRequired,
    browserName: PropTypes.string
};

export default ServicesIcons;
