import {knownOrigins} from '@blocks/registration/customizations/customization';

export default function mapStateToProps(state) {
    const {
        fetchingStatus = {},
        settings: {origin, tld, uatraits, staticPath},
        experimentsList = {}
    } = state;
    const browserName = uatraits.BrowserName;
    const isMobile = uatraits.isMobile && !uatraits.isTablet;

    return {
        fetchingStatus,
        origin,
        tld,
        browserName,
        staticPath,
        isMobile,
        isPlusPromo: experimentsList.isPlusPromo,
        resultOrigin: knownOrigins.includes(origin) ? origin : 'default'
    };
}
