import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {Button} from '@components/Button';
import RegistrationForm from './registration_form.jsx';
import RegistrationLite from '../../registration-lite/RegistrationLite.jsx';
import FormHeader from '../commonComponents/FormHeader.jsx';
import Promo from './promo/Promo.jsx';
import classnames from 'classnames';
import mapStateToProps from './';

export const RegContent = ({errors, registrationType = 'default', isMobile}) => {
    const REGISTRATIONS_LIST = {
        lite: RegistrationLite,
        default: RegistrationForm,
        childish: RegistrationForm
    };
    const RegistrationComponentToRender = REGISTRATIONS_LIST[registrationType];

    if (errors.status === 'error') {
        return (
            <div className='global__error'>
                <strong className='global__error-title'>{errors.text}</strong>
                <p dangerouslySetInnerHTML={{__html: errors.descriptionText}} />
                {errors.code === 'sessionidoverflow' && (
                    <div className='global__error-btn'>
                        <Button view='action' size={isMobile ? 'm' : 'l'} type='link' url='/auth'>
                            {i18n('Frontend.registration_edit-userlist_btn')}
                        </Button>
                    </div>
                )}
            </div>
        );
    }
    return (
        <div>
            <RegistrationComponentToRender />
        </div>
    );
};

RegContent.propTypes = {
    errors: PropTypes.object.isRequired,
    registrationType: PropTypes.string,
    isMobile: PropTypes.bool
};

export class Registration extends Component {
    render() {
        const {registrationErrors, isMobile, registrationType, skipPromo} = this.props;
        const isLiteRegistration = registrationType === 'lite';

        return (
            <div
                className={classnames({
                    'main-container': !isMobile,
                    registration__lite: registrationType,
                    is_mobile_reg: isMobile,
                    'mobile_unified-experiment': isMobile && !isLiteRegistration
                })}
            >
                <Promo skipPromo={skipPromo} />
                <main
                    className={classnames('registration__wrapper', {
                        registration__wrapper_desktop: !isMobile && !skipPromo,
                        registration__wrapper_simple: skipPromo && !isMobile
                    })}
                >
                    <FormHeader />
                    <div
                        className={classnames({
                            registration__block: !isMobile,
                            'registration__block-mobile': isMobile
                        })}
                    >
                        <RegContent
                            isMobile={isMobile}
                            errors={registrationErrors}
                            registrationType={registrationType}
                        />
                    </div>
                </main>
            </div>
        );
    }
}

Registration.propTypes = {
    registrationErrors: PropTypes.object,
    registrationType: PropTypes.string,
    servicesIcons: PropTypes.array,
    dispatch: PropTypes.func,
    footer: PropTypes.object.isRequired,
    isMobile: PropTypes.bool,
    settings: PropTypes.object.isRequired,
    skipPromo: PropTypes.string
};

export default connect(mapStateToProps)(Registration);
