export const errorsTxt = {
    firstname: {
        errors: {
            empty: i18n('_AUTH_.firstname_errors_missingvalue'),
            missingvalue: i18n('_AUTH_.firstname_errors_missingvalue'),
            toolong: i18n('_AUTH_.firstname_errors_toolong'),
            invalid: i18n('_AUTH_.NewRegNotes.noiname'),
            'firstname.invalid': i18n('_AUTH_.NewRegNotes.noiname'),
            'firstname.long': i18n('_AUTH_.firstname_errors_toolong')
        }
    },
    lastname: {
        errors: {
            empty: i18n('_AUTH_.lastname_errors_missingvalue'),
            missingvalue: i18n('_AUTH_.lastname_errors_missingvalue'),
            toolong: i18n('_AUTH_.lastname_errors_toolong'),
            invalid: i18n('_AUTH_.NewRegNotes.nofname'),
            'lastname.invalid': i18n('_AUTH_.NewRegNotes.nofname'),
            'lastname.long': i18n('_AUTH_.lastname_errors_toolong')
        }
    },
    birthday: {
        errors: {
            invalid: i18n('Frontend.birthday_errors_invalid'),
            missingvalue: i18n('Frontend.birthday_errors_invalid')
        }
    },
    login: {
        errors: {
            'login.empty': i18n('_AUTH_.login_errors_missingvalue'),
            'login.missingvalue': i18n('_AUTH_.login_errors_missingvalue'),
            missingvalue: i18n('_AUTH_.login_errors_missingvalue'),
            'login.invalid': i18n('_AUTH_.login_errors_incorrect'),
            'login.domain_invalid_type': i18n('_AUTH_.login_errors_invalid'),
            notavailable: i18n('_AUTH_.login_error_notavailable'),
            'login.not_available': i18n('_AUTH_.login_error_notavailable'),
            'login.prohibitedsymbols': i18n('_AUTH_.login_errors_incorrect'),
            'login.startswithdigit': i18n('_AUTH_.login_errors_incorrect'),
            'login.long': i18n('_AUTH_.login_errors_incorrect'),
            'login.startswithdot': i18n('_AUTH_.login_errors_incorrect'),
            'login.startswithhyphen': i18n('_AUTH_.login_errors_incorrect'),
            'login.endswithhyphen': i18n('_AUTH_.login_errors_incorrect'),
            'login.doubleddot': i18n('_AUTH_.login_errors_incorrect'),
            'login.doubledhyphen': i18n('_AUTH_.login_errors_incorrect'),
            'login.dothyphen': i18n('_AUTH_.login_errors_incorrect'),
            'login.hyphendot': i18n('_AUTH_.login_errors_incorrect'),
            'login.endwithdot': i18n('_AUTH_.login_errors_incorrect'),
            'login.like_password': i18n('_AUTH_.login_errors_likepassword')
        },
        descriptions: {
            'login.invalid': i18n('_AUTH_.login_error_description_invalid'),
            'login.not_available': i18n('_AUTH_.login_error_description_notavailable'),
            'login.prohibitedsymbols': i18n('_AUTH_.login_error_description_invalid'),
            'login.startswithdigit': i18n('_AUTH_.login_errors_startswithdigit'),
            'login.long': i18n('_AUTH_.login_errors_toolong'),
            'connect.login.long': i18n('_AUTH_.connect_login_errors_toolong'),
            'login.startswithdot': i18n('_AUTH_.login_errors_startswithdot'),
            'login.startswithhyphen': i18n('_AUTH_.login_errors_startswithhyphen'),
            'login.endswithhyphen': i18n('_AUTH_.login_errors_endswithhyphen'),
            'login.doubleddot': i18n('_AUTH_.login_errors_doubleddot'),
            'login.doubledhyphen': i18n('_AUTH_.login_errors_doubledhyphen'),
            'login.dothyphen': i18n('_AUTH_.login_errors_dothyphen'),
            'login.hyphendot': i18n('_AUTH_.login_errors_hyphendot'),
            'login.endwithdot': i18n('_AUTH_.login_errors_endswithdot')
        }
    },
    domain: {
        errors: {
            missingvalue: i18n('_AUTH_.field_workspace_orgdomain_error_missingvalue'),
            'domain.missingvalue': i18n('_AUTH_.field_workspace_orgdomain_error_missingvalue'),
            'domain.already_exists': i18n('_AUTH_.domain.already_exists.error'),
            'domain.invalid': i18n('_AUTH_.domain.invalid.error'),
            'domain.invalid_type': i18n('_AUTH_.domain.invalid.error'),
            'domain.containssubdomain': i18n('_AUTH_.domain.sub.error')
        },
        descriptions: {
            'domain.invalid': i18n('_AUTH_.domain.invalid.desc'),
            'domain.containssubdomain': i18n('_AUTH_.domain.sub.desc'),
            'domain.already_exists': i18n('_AUTH_.domain.already_exists.desc')
        }
    },
    password: {
        errors: {
            not_matched: i18n('_AUTH_.password_current_errors_not_matched'),
            'password.not_matched': i18n('_AUTH_.password_current_errors_not_matched'),
            'password.not_matched.2fa': i18n('Errors.ErrorsTexts.badlog_2fa'),
            likelogin: i18n('_AUTH_.password_errors_likelogin'),
            tooshort: i18n('_AUTH_.password_errors_tooshort'),
            'password.short': i18n('_AUTH_.password_errors_tooshort'),
            'strong_pwd.tooshort': i18n('_AUTH_.password.strong_errors_weak'),
            weak: i18n('_AUTH_.password_errors_weak'),
            'warning.weak': i18n('_AUTH_.password_errors_tooweak'),
            prohibitedsymbols: i18n('_AUTH_.password_errors_prohibitedsymbols'),
            missingvalue: i18n('_AUTH_.password_errors_missingvalue'),
            empty: i18n('_AUTH_.password_errors_missingvalue'),
            'password.empty': i18n('_AUTH_.password_errors_missingvalue'),
            missingvalue_current: i18n('_AUTH_.password_current_errors_missingvalue'),
            empty_current: i18n('_AUTH_.password_current_errors_missingvalue'),
            'current_password.empty': i18n('_AUTH_.password_current_errors_missingvalue'),
            likeoldpassword: i18n('_AUTH_.password_errors_equals_previous'),
            equals_previous: i18n('_AUTH_.password_errors_equals_previous'),
            'password.equals_previous': i18n('_AUTH_.password_errors_equals_previous'),
            'password.found_in_history': i18n('_AUTH_.password_errors_foundinhistory'),
            foundinhistory: i18n('_AUTH_.password_errors_foundinhistory'),
            likephonenumber: i18n('_AUTH_.password_errors_likephonenumber'),
            toolong: i18n('_AUTH_.password_errors_toolong')
        },
        descriptions: {
            likelogin: i18n('_AUTH_.password_error_likelogin-description'),
            tooshort: i18n('_AUTH_.password_error_description-tooshort'),
            'password.short': i18n('_AUTH_.password_error_description-tooshort'),
            weak: i18n('_AUTH_.password_errors_description-weak'),
            'warning.weak': i18n('_AUTH_.password_errors_tooweak_description'),
            prohibitedsymbols: i18n('_AUTH_.password_errors_description-prohibited-symbols'),
            likeoldpassword: i18n('_AUTH_.password_error_likelogin-description'),
            foundinhistory: i18n('_AUTH_.password_error_likelogin-description'),
            likephonenumber: i18n('_AUTH_.password_error_likelogin-description')
        }
    },
    password_confirm: {
        errors: {
            empty: i18n('_AUTH_.password_confirm_errors_missingvalue'),
            missingvalue: i18n('_AUTH_.password_confirm_errors_missingvalue'),
            notequal: i18n('_AUTH_.password_confirm_errors_notequal')
        }
    },
    current_password: {
        errors: {
            missingvalue: i18n('_AUTH_.password_current_errors_missingvalue')
        }
    },
    phone: {
        errors: {
            missingvalue: i18n('_AUTH_.phone_number_errors_missingvalue'),
            'number.empty': i18n('_AUTH_.phone_number_errors_missingvalue'),
            'phone_number.empty': i18n('_AUTH_.phone_number_errors_missingvalue'),
            'number.invalid': i18n('_AUTH_.phone_number_errors_badphonenumber'),
            'phone_number.invalid': i18n('_AUTH_.phone_number_errors_badphonenumber'),
            'code.invalid': i18n('_AUTH_.phone-confirm_errors_codeinvalid'),
            'code.missingvalue': i18n('_AUTH_.phone-confirm_errors_missingvalue'),
            'sms_limit.exceeded': i18n('_AUTH_.phones.errors.limit-exceeded'),
            badphonenumber: i18n('_AUTH_.phone_number_errors_badphonenumber'),
            needsconfirmation: i18n('_AUTH_.phone-confirm_errors_needs_confirmation'),
            couldnotsend: i18n('_AUTH_.phone-confirm_errors_couldnotsend'),
            compromised: i18n('_AUTH_.phone-confirm_errors_compromised'),
            'phone_alias.exist': i18n('_AUTH_.phone-confirm_errors_phone_alias_exist'),
            'phone_secure.bound_and_confirmed': i18n('_AUTH_.phone-confirm_errors_bound_and_confirmed'),
            bound_and_confirmed: i18n('_AUTH_.phone-confirm_errors_bound_and_confirmed'),
            'confirmations_limit.exceeded': i18n(
                '_AUTH_.phone-confirm_errors_confirmations_limitexceeded_change_number'
            ),
            limitexceeded_one_number: i18n('_AUTH_.phone-confirm_errors_confirmations_limitexceeded_one_number'),
            invalidsecurephone: i18n('_AUTH_.phone-confirm_errors_invalidsecurephone'),
            not_matched: i18n('_AUTH_.phone-confirm_errors_invalidsecurephone'),
            invalidcaptcha: i18n('_AUTH_.phone-confirm_errors_invalidcaptcha'),
            'phone.compromised': i18n('_AUTH_.phone-confirm_errors_compromised_v2'),
            'calls_limit.exceeded': i18n('_AUTH_.phone-calls-limit-exceeded'),
            'call_confirm.failed': i18n('_AUTH_.call-confirm-failed'),
            'csrf_token.invalid': i18n('_AUTH_.avatar.error-internal'),
            'action.not_required': i18n('_AUTH_.phones.errors.phone.issecure'),
            'phone.is_bank_phonenumber_alias': i18n('Phones.phones.v2.blocked_number_error'),
            'phone.not_matched': i18n('_AUTH_.phone-confirm_errors_invalidsecurephone'),
            'login.prohibitedsymbols': i18n('_AUTH_.phone_number_errors_badphonenumber'),
            'login.startswithdigit': i18n('_AUTH_.phone_number_errors_badphonenumber')
        }
    },
    phoneCode: {
        errors: {
            missingvalue: i18n('_AUTH_.phone-confirm_errors_missingvalue'),
            'code.invalid': i18n('_AUTH_.phone-confirm_errors_codeinvalid'),
            'code.missingvalue': i18n('_AUTH_.phone-confirm_errors_missingvalue'),
            'code.empty': i18n('_AUTH_.phone-confirm_errors_missingvalue'),
            'sms_limit.exceeded': i18n('_AUTH_.phones.errors.limit-exceeded'),
            needsconfirmation: i18n('_AUTH_.phone-confirm_errors_needs_confirmation'),
            couldnotsend: i18n('_AUTH_.phone-confirm_errors_couldnotsend'),
            compromised: i18n('_AUTH_.phone-confirm_errors_compromised'),
            'phone_secure.bound_and_confirmed': i18n('_AUTH_.phone-confirm_errors_bound_and_confirmed'),
            bound_and_confirmed: i18n('_AUTH_.phone-confirm_errors_bound_and_confirmed'),
            'confirmations_limit.exceeded': i18n('_AUTH_.phones.errors.confirmation-limit-exceeded'),
            'challenge.confirmations_limit.exceeded': i18n('_AUTH_.phones.errors.confirmation-limit-exceeded'),
            limitexceeded_one_number: i18n('_AUTH_.phone-confirm_errors_confirmations_limitexceeded_one_number'),
            invalidsecurephone: i18n('_AUTH_.phone-confirm_errors_invalidsecurephone'),
            not_matched: i18n('_AUTH_.phone-confirm_errors_invalidsecurephone'),
            invalidcaptcha: i18n('_AUTH_.phone-confirm_errors_invalidcaptcha'),
            'phone.compromised': i18n('_AUTH_.phone-confirm_errors_compromised_v2'),
            'calls_limit.exceeded': i18n('_AUTH_.phone-calls-limit-exceeded'),
            'call_confirm.failed': i18n('_AUTH_.call-confirm-failed'),
            'csrf_token.invalid': i18n('_AUTH_.avatar.error-internal'),
            global: i18n('_AUTH_.errors.globalinternal')
        }
    },
    hint: {
        hintQuestionErrors: {
            missingvalue: i18n('_AUTH_.hint_question_id_errors_missingvalue'),
            toolong: i18n('_AUTH_.hint_question_errors_toolong'),
            empty: i18n('_AUTH_.hint_question_errors_missingvalue')
        },
        hintAnswerErrors: {
            missingvalue: i18n('_AUTH_.hint_answer_errors_missingvalue'),
            toolong: i18n('_AUTH_.hint_answer_errors_toolong')
        }
    },
    hint_answer: {
        errors: {
            empty: i18n('_AUTH_.hint_answer_errors_missingvalue'),
            missingvalue: i18n('_AUTH_.hint_answer_errors_missingvalue'),
            toolong: i18n('_AUTH_.hint_answer_errors_toolong')
        }
    },
    hint_question_custom: {
        errors: {
            missingvalue: i18n('_AUTH_.hint_question_id_errors_missingvalue'),
            toolong: i18n('_AUTH_.hint_question_errors_toolong'),
            empty: i18n('_AUTH_.hint_question_errors_missingvalue')
        }
    },
    captcha: {
        errors: {
            missingvalue: i18n('_AUTH_.answer_errors_missingvalue'),
            'answer.empty': i18n('_AUTH_.answer_errors_missingvalue'),
            'captcha.empty': i18n('_AUTH_.answer_errors_missingvalue'),
            'captcha.cannot_locate': i18n('_AUTH_.answer_errors_captchalocate'),
            'captcha.not_matched': i18n('_AUTH_.answer_errors_incorrect'),
            'csrf_token.invalid': i18n('_AUTH_.avatar.error-internal')
        }
    },
    registration: {
        errors: {
            sessionidoverflow: i18n('_AUTH_.ErrorsTexts.sessionidoverflow_reg'),
            registrationsmssendperiplimitexceeded: i18n('_AUTH_.ErrorsTexts.registrationsmssendperiplimitexceeded')
        },
        descriptions: {
            sessionidoverflow: i18n('_AUTH_.MendTexts.sessionidoverflow_reg')
        }
    },
    global: {
        errors: {
            global: i18n('_AUTH_.errors.globalinternal'),
            smthWrong: i18n('_AUTH_.avatar.error-internal')
        }
    },
    findAccountsByNameAndPhone: {
        errors: {
            'rate.limit_exceeded': i18n('_AUTH_.errors.findaccountsbynameandphone.limit_exceeded.title')
        },
        descriptions: {
            'rate.limit_exceeded': i18n('_AUTH_.errors.findaccountsbynameandphone.limit_exceeded.description')
        }
    },
    neoPhonishAuth: {
        errors: {
            'rate.limit_exceeded': i18n('_AUTH_.errors.neophonishauth.limit_exceeded.title')
        },
        descriptions: {
            'rate.limit_exceeded': i18n('_AUTH_.errors.neophonishauth.limit_exceeded.description')
        }
    },
    email: {
        errors: {
            'email.invalid': i18n('_AUTH_.emails.errors.email-invalid'),
            'email.already_confirmed': i18n('_AUTH_.emails.errors.already-confirmed'),
            'email.is_native': i18n('_AUTH_.emails.errors.is-native'),
            'email.already_sent': i18n('_AUTH_.emails.errors.already-sent'),
            'email.not_found': i18n('_AUTH_.error.email-not-found'),
            'email.empty': i18n('_AUTH_.import.email_empty'),
            'email.send_limit_exceeded': i18n('_AUTH_.login_email-send_limit_exceeded'),
            'email_confirmations_limit.exceeded': i18n('_AUTH_.code_errors-check_limit_exceeded')
        }
    },
    email_code: {
        errors: {
            'key.empty': i18n('_AUTH_.email.key.empty'),
            'email.incorrect_key': i18n('_AUTH_.phones.errors.code.invalid'),
            'email.key_check_limit_exceeded': i18n('_AUTH_.code_errors-check_limit_exceeded')
        }
    },
    publicId: {
        errors: {
            missingvalue: i18n('_AUTH_.publicId.missingvalue_error'),
            'public_id.empty': i18n('_AUTH_.publicId.missingvalue_error'),
            'public_id.not_available': i18n('_AUTH_.publicId.unavailable_error'),
            'public_id.long': i18n('_AUTH_.publicId.toolong_error'),
            'public_id.startswithdigit': i18n('_AUTH_.publicId.digit_error'),
            'public_id.startswithdot': i18n('_AUTH_.publicId.dot_error'),
            'public_id.startswithhyphen': i18n('_AUTH_.publicId.hyphen_error'),
            'public_id.endwithdot': i18n('_AUTH_.publicId.dot-end_error'),
            'public_id.endswithhyphen': i18n('_AUTH_.publicId.hyphen-end_error'),
            'public_id.doubleddot': i18n('_AUTH_.publicId.dd-dot_error'),
            'public_id.doubledhyphen': i18n('_AUTH_.profilePublic.dd-hyphen_error'),
            'public_id.prohibitedsymbols': i18n('_AUTH_.publicId.prohibiteb-sym_error'),
            'public_id.dothyphen': i18n('_AUTH_.publicId.dot-hyphen.error'),
            'public_id.hyphendot': i18n('_AUTH_.publicId.dot-hyphen.error'),
            'public_id.update_not_allowed': i18n('_AUTH_.publicId.limit-exceeded'),
            'public_id.invalid': i18n('_AUTH_.inputname.invalid')
        }
    }
};
