import React, {useMemo} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';

import {Button} from '@components/Button';

const AuthLink = ({isMobile, authUrl, experimentFlags}) => {
    const renderButton = useMemo(() => experimentFlags.includes('reg-login-button-exp'), [experimentFlags]);

    if (isMobile) {
        return null;
    }

    const linkText = i18n('Frontend.logon');

    return (
        <div className='registration-auth-link'>
            {i18n('Frontend.already_have_login')}
            {renderButton && (
                <span className='registration-auth-link__link registration-auth-link__link_as-button'>
                    <Button view='pseudo' size='l' url={authUrl} type='link' title={linkText}>
                        {linkText}
                    </Button>
                </span>
            )}
            {!renderButton && (
                <a className='registration-auth-link__link' href={authUrl} title={linkText}>
                    {linkText}
                </a>
            )}
        </div>
    );
};

AuthLink.propTypes = {
    isMobile: PropTypes.bool,
    authUrl: PropTypes.string,
    experimentFlags: PropTypes.array.isRequired
};

export default connect(({common: {experiments: {flags = []} = {}} = {}}) => ({
    experimentFlags: flags
}))(AuthLink);
