import React from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import EulaPopup from '../desktop/eula/EulaPopup.jsx';

const FormSubmit = ({
    isLoading,
    size,
    disable,
    onSubmit,
    isEulaByPopup,
    sendData,
    text = i18n('Profile.regpromo.register')
} = {}) => (
    <div className='form__submit' data-t='registration:btn-submit'>
        {/* PASSP-20339: На регистрации лайтов без JS задизейблена кнопка Зарегистрироваться */}
        {isLoading && (
            <div className='no-js-submit'>
                <Button view='action' size='l' width='max' type='submit'>
                    {text}
                </Button>
            </div>
        )}

        <span className='js-submit'>
            <Button view='action' size={size || 'l'} width='max' type='submit' disabled={disable} onClick={onSubmit}>
                {text}
            </Button>
        </span>

        {isEulaByPopup && <EulaPopup sendData={sendData} showSubscrCheckbox={true} />}
    </div>
);

FormSubmit.propTypes = {
    sendData: PropTypes.func,
    disable: PropTypes.bool.isRequired,
    onSubmit: PropTypes.func.isRequired,
    isEulaByPopup: PropTypes.bool,
    isLoading: PropTypes.bool,
    size: PropTypes.string,
    text: PropTypes.string
};

export default FormSubmit;
