import React from 'react';
import PropTypes from 'prop-types';

const RegistrationTitle = ({isMobile, skipPromo, title = i18n('_AUTH_.registration-title')}) => {
    if (isMobile && !skipPromo) {
        return null;
    }
    return (
        <div className='registration__header registration__header_desktop'>
            <h1 className='header__descr'>{title}</h1>
        </div>
    );
};

RegistrationTitle.propTypes = {
    isMobile: PropTypes.bool,
    skipPromo: PropTypes.bool,
    title: PropTypes.string
};

export default RegistrationTitle;
