import React from 'react';
import PropTypes from 'prop-types';
import {BirthdayField} from '@components/BirthdayField';
import FieldPopup from '@blocks/registration/desktop/errorPopup/error_popup';
import {getError} from '@blocks/utils';
import classnames from 'classnames';
import {FIELDS_NAMES} from '@components/Field/names';

const PLACEHOLDERS = {
    day: i18n('_AUTH_.registration.birthday.placeholder.day'),
    year: i18n('_AUTH_.registration.birthday.placeholder.year')
};

export class BirthdayInput extends React.Component {
    checkFieldPopupVisible() {
        const {isMobile, activeField, error} = this.props;

        if (isMobile) {
            return Boolean(error);
        }
        return error && activeField === FIELDS_NAMES.BIRTHDAY;
    }
    handleFocus = () => {
        const {setFieldErrorActive, changeActiveField} = this.props;

        setFieldErrorActive('');
        changeActiveField(FIELDS_NAMES.BIRTHDAY);
    };
    onChangeEvent = (value) => {
        const {updateValues} = this.props;

        updateValues({field: FIELDS_NAMES.BIRTHDAY, value});
    };
    setError = (errorCode = '') => {
        const {updateErrors, updateStates} = this.props;

        updateStates({field: FIELDS_NAMES.BIRTHDAY, status: errorCode ? 'not_valid' : 'valid'});
        updateErrors({
            field: FIELDS_NAMES.BIRTHDAY,
            error: errorCode ? getError(FIELDS_NAMES.BIRTHDAY, errorCode) : ''
        });
    };
    render() {
        const {value, error, state} = this.props;
        const popupVisible = this.checkFieldPopupVisible();
        const isNotValid = state === 'not_valid';

        return (
            <div
                className={classnames('form__field', {
                    field__error: isNotValid
                })}
            >
                <div className={'registration__label registration__label-static'}>
                    {i18n('_AUTH_.registration.birthday.label')}
                </div>
                <BirthdayField
                    onChange={this.onChangeEvent}
                    onFocus={this.handleFocus}
                    setError={this.setError}
                    value={value}
                    dayPlaceholder={PLACEHOLDERS.day}
                    yearPlaceholder={PLACEHOLDERS.year}
                    error={error}
                    isRequired={true}
                />
                <FieldPopup fieldName={FIELDS_NAMES.BIRTHDAY} visible={popupVisible}>
                    <div className='form__popup-error' data-t='birthday-error' role='alert'>
                        <div className='error-message'>{error}</div>
                    </div>
                </FieldPopup>
            </div>
        );
    }
}

BirthdayInput.propTypes = {
    value: PropTypes.string,
    error: PropTypes.error,
    state: PropTypes.string,
    updateStates: PropTypes.func.isRequired,
    updateErrors: PropTypes.func.isRequired,
    updateValues: PropTypes.func.isRequired,
    changeActiveField: PropTypes.func.isRequired,
    setFieldErrorActive: PropTypes.func.isRequired,
    activeField: PropTypes.string,
    isMobile: PropTypes.bool
};
