import React from 'react';
import PropTypes from 'prop-types';
import {RadioButton} from '@components/RadioButton';

const GENDER_OPTIONS = [
    {
        children: i18n('_AUTH_.registration.gender.childish.option.m'),
        value: 'm',
        'data-t': 'registration:gender:m'
    },
    {
        children: i18n('_AUTH_.registration.gender.childish.option.f'),
        value: 'f',
        'data-t': 'registration:gender:f'
    }
];

export class GenderInput extends React.Component {
    onChangeEvent = (evt) => {
        const {updateUserField} = this.props;

        updateUserField(evt);
    };
    render() {
        const {value} = this.props;

        return (
            <div className='form__field'>
                <div className={'registration__label registration__label-static'}>
                    {i18n('_AUTH_.registration.gender.label')}
                </div>
                <RadioButton
                    width='max'
                    value={value}
                    options={GENDER_OPTIONS}
                    name='gender'
                    onChange={this.onChangeEvent}
                />
            </div>
        );
    }
}

GenderInput.propTypes = {
    value: PropTypes.string,
    updateUserField: PropTypes.func.isRequired
};
