import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Modal} from '@components/Modal';
import {Captcha} from '@screens/Captcha';

import './CaptchaModal.styl';

export class CaptchaModal extends Component {
    checkCaptcha = (event) => {
        const {setCaptchaRequired} = this.props;

        if (event) {
            event.preventDefault();
        }

        setCaptchaRequired(false);
    };

    render() {
        return (
            <Modal visible={true} dataT='registration:captcha_modal'>
                <div className='CaptchaModal'>
                    <Captcha onConfirmCallback={this.checkCaptcha} />
                </div>
            </Modal>
        );
    }
}

CaptchaModal.propTypes = {
    setCaptchaRequired: PropTypes.func
};
