import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Input} from '@components/Input';
import HintQuestion from './hint_question.jsx';
import ControlQuestionsPopup from './hint_question-popup.jsx';
import classnames from 'classnames';
import checkIfInvalid from '../../../methods/checkIfInvalid';
import validateHint from '../../../methods/validateHint';

export default class ControlQuestions extends PureComponent {
    constructor(props) {
        super(props);

        this.validateCustomQuestion = this.validateCustomQuestion.bind(this);
        this.validateHintAnswer = this.validateHintAnswer.bind(this);
        this.checkInvalid = this.checkInvalid.bind(this);

        this.isLoading = true;
    }

    componentDidMount() {
        this.isLoading = false;

        if (this.props.hintAnswerState === 'need_validation') {
            this.validateHintAnswer(this.props.hint_answer);
        }

        this.forceUpdate();
    }

    validateCustomQuestion() {
        const data = {
            hint_question_id: '99',
            hint_question: this.props.hint_question_custom
        };

        this.props.dispatch(validateHint(data, 'question'));
    }

    validateHintAnswer() {
        const data = {
            hint_answer: this.props.hint_answer
        };

        this.props.dispatch(validateHint(data, 'answer'));
    }

    checkInvalid() {
        this.props.dispatch(checkIfInvalid('hint_question_custom'));
    }

    render() {
        const questionsList = this.props.humanConfirmation.questionList;
        const {
            errors,
            hint_question_custom,
            hint_question,
            hint_question_id,
            hint_answer,
            hintQuestionCustomState,
            hintQuestionState,
            hintAnswerState,
            canSwitchConfirmationMethod,
            activeError
        } = this.props;

        return (
            <div className='control-questions-wrapper'>
                <HintQuestion
                    hint_question_id={hint_question_id}
                    hint_question={hint_question}
                    questionsList={questionsList}
                    hintQuestionState={hintQuestionState}
                    activeError={activeError}
                    canSwitchConfirmationMethod={canSwitchConfirmationMethod}
                    errors={errors}
                    onSelectChange={this.props.onSelectChange}
                    handleConfirmation={this.props.handleConfirmation}
                />

                {hint_question_id === '99' && (
                    <div
                        className={classnames('form__field hint_question_custom_field', {
                            form__field_filled: hint_question_custom,
                            field__error: hintQuestionCustomState === 'not_valid',
                            field__valid: hintQuestionCustomState === 'valid'
                        })}
                    >
                        <Input
                            id='hint_question_custom'
                            value={hint_question_custom}
                            name='hint_question_custom'
                            controlRef={(hint_question_custom) => (this.hint_question_custom = hint_question_custom)}
                            onFocus={this.checkInvalid}
                            onBlur={this.validateCustomQuestion}
                            onChange={this.props.onInputChange}
                            view='one-border'
                            state={hintQuestionCustomState === 'not_valid' ? 'error' : ''}
                            filled={!!hint_question_custom}
                        />
                        <label htmlFor='hint_question_custom' className='registration__label'>
                            {i18n('_AUTH_.question_enter_custom')}
                        </label>
                        <ControlQuestionsPopup
                            notValid={hintQuestionCustomState === 'not_valid'}
                            error={activeError === 'hint_question_custom'}
                            anchor={this.hint_question_custom}
                            message={errors.hint_question_custom.text}
                            field='hint_question_custom'
                        />
                    </div>
                )}

                <div
                    className={classnames('form__field hint_answer_field', {
                        form__field_filled: hint_answer || this.isLoading,
                        field__error: hintAnswerState === 'not_valid',
                        field__valid: hintAnswerState === 'valid'
                    })}
                >
                    <Input
                        id='hint_answer'
                        value={hint_answer}
                        name='hint_answer'
                        controlRef={(hint_answer) => (this.hint_answer = hint_answer)}
                        onBlur={this.validateHintAnswer}
                        onChange={this.props.onInputChange}
                        view='one-border'
                        state={hintAnswerState === 'not_valid' ? 'error' : ''}
                        filled={!!hint_answer || this.isLoading}
                    />
                    <label htmlFor='hint_answer' className='registration__label'>
                        {i18n('_AUTH_.field_hint_answer')}
                    </label>
                    <ControlQuestionsPopup
                        notValid={hintAnswerState === 'not_valid'}
                        error={activeError === 'hint_answer'}
                        anchor={this.hint_answer}
                        message={errors.hint_answer && errors.hint_answer.text}
                        field='hint_answer'
                    />
                </div>
            </div>
        );
    }
}

ControlQuestions.propTypes = {
    dispatch: PropTypes.func.isRequired,
    controlQuestion: PropTypes.object,
    onInputChange: PropTypes.func.isRequired,
    onSelectChange: PropTypes.func.isRequired,
    questionsList: PropTypes.array.isRequired,
    handleConfirmation: PropTypes.func.isRequired,
    humanConfirmation: PropTypes.object.isRequired,
    hint_question_custom: PropTypes.string,
    hint_question: PropTypes.string,
    hint_question_id: PropTypes.string,
    hint_answer: PropTypes.string,
    hintQuestionCustomState: PropTypes.string,
    canSwitchConfirmationMethod: PropTypes.bool.isRequired,
    hintQuestionState: PropTypes.string,
    hintAnswerState: PropTypes.string,
    activeError: PropTypes.string,
    errors: PropTypes.object
};
