import React from 'react';
import PropTypes from 'prop-types';
import FieldPopup from '../../../desktop/errorPopup/error_popup.jsx';

const ControlQuestionsPopup = (props) => (
    <FieldPopup fieldName={props.field}>
        <div className='form__popup-error' data-t={`${props.field}-error`} role='alert'>
            <div className='error-message'>{props.message}</div>
        </div>
    </FieldPopup>
);

export default ControlQuestionsPopup;

ControlQuestionsPopup.propTypes = {
    field: PropTypes.string.isRequired,
    message: PropTypes.string
};
