import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Link} from '@components/Link';
import ControlQuestionsPopup from './hint_question-popup.jsx';
import {Select} from '@components/Select';

class HintQuestion extends PureComponent {
    constructor(props) {
        super(props);

        this.isLoading = true;
    }

    componentDidMount() {
        this.isLoading = false;
        this.forceUpdate();
    }

    render() {
        const {
            errors,
            onSelectChange,
            hintQuestionState,
            activeError,
            canSwitchConfirmationMethod,
            questionsList,
            hint_question_id
        } = this.props;

        return (
            <div className='form__field control_question_field form__field_filled'>
                <label htmlFor='control_question' className='registration__label question-select__label'>
                    {i18n('_AUTH_.field_hint_question_id')}
                </label>

                <div data-t='user-question-all'>
                    <Select
                        name='hint_question_id'
                        id='hint_question_id'
                        dataT='hint_question_id'
                        size='l'
                        onChange={onSelectChange}
                        options={questionsList.map((question) => ({value: question.val, content: question.text}))}
                        width='max'
                        value={hint_question_id}
                    />
                </div>

                {canSwitchConfirmationMethod && !this.isLoading && (
                    <div className='registration__pseudo-link'>
                        <Link onClick={this.props.handleConfirmation}>
                            {i18n('Frontend.field_human-confirmation_switch-to-phone')}
                        </Link>
                    </div>
                )}

                <ControlQuestionsPopup
                    notValid={hintQuestionState === 'not_valid'}
                    error={activeError === 'hint_question'}
                    anchor={this.hint_question}
                    message={errors.hint_question && errors.hint_question.text}
                    field='hint_question'
                />
            </div>
        );
    }
}

HintQuestion.propTypes = {
    errors: PropTypes.object,
    hint_question_id: PropTypes.string,
    hint_question: PropTypes.string,
    hintQuestionState: PropTypes.string,
    activeError: PropTypes.string,
    canSwitchConfirmationMethod: PropTypes.bool.isRequired,
    questionsList: PropTypes.array,
    onSelectChange: PropTypes.func.isRequired,
    handleConfirmation: PropTypes.func.isRequired
};

export default HintQuestion;
