import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {Spin} from '@components/Spin';
import {
    updateQuestionValues,
    updateQuestionStates,
    updateQuestionCustomState,
    updateValues
} from '@blocks/actions/form';
import ControlQuestions from './control_questions.jsx';

class UserQuestions extends PureComponent {
    static mapStateToProps(state) {
        const {
            form: {values, states, errors, humanConfirmation, canSwitchConfirmationMethod}
        } = state;

        return {
            values,
            states,
            errors,
            humanConfirmation,
            canSwitchConfirmationMethod
        };
    }

    constructor(props) {
        super(props);

        this.onInputChange = this.onInputChange.bind(this);
        this.handleConfirmation = this.handleConfirmation.bind(this);
        this.onSelectChange = this.onSelectChange.bind(this);

        this.errors = {
            missingvalue: '%hint_question_errors_missingvalue',
            toolong: '%hint_question_errors_toolong'
        };
    }

    onInputChange(event) {
        const {target = {}} = event;
        const {value, name} = target;

        const fieldInfo = {
            field: name,
            value
        };

        this.props.dispatch(updateValues(fieldInfo));
    }

    handleConfirmation() {
        this.props.toggleConfirmationMethod();
    }

    onSelectChange(event) {
        const selectVal = event.target.value;
        const {humanConfirmation, dispatch} = this.props;
        const selected = humanConfirmation.questionList.find((question) => question.val === selectVal);
        const questionData = {
            hint_question_id: selected.val,
            hint_question: selected.text
        };

        dispatch(updateQuestionValues(questionData));
        dispatch(updateQuestionStates({status: 'valid'}));

        if (selected.val !== '99') {
            dispatch(updateQuestionCustomState({status: 'valid'}));
        } else {
            dispatch(updateQuestionCustomState({status: ''}));
        }
    }

    render() {
        const {states, values, errors, dispatch, humanConfirmation, canSwitchConfirmationMethod} = this.props;
        const questionsList = humanConfirmation.questionList;

        if (questionsList.length === 0) {
            return <Spin progress={true} size='l' />;
        }

        return (
            <ControlQuestions
                hint_answer={values.hint_answer}
                hint_question_id={values.hint_question_id}
                hint_question={values.hint_question}
                hint_question_custom={values.hint_question_custom}
                hintQuestionState={states.hint_question}
                hintQuestionCustomState={states.hint_question_custom}
                hintAnswerState={states.hint_answer}
                activeError={errors.active}
                questionsList={questionsList}
                errors={errors}
                humanConfirmation={humanConfirmation}
                canSwitchConfirmationMethod={canSwitchConfirmationMethod}
                onSelectChange={this.onSelectChange}
                onInputChange={this.onInputChange}
                handleConfirmation={this.handleConfirmation}
                dispatch={dispatch}
            />
        );
    }
}

export default connect(UserQuestions.mapStateToProps)(UserQuestions);

UserQuestions.propTypes = {
    states: PropTypes.object,
    values: PropTypes.object,
    errors: PropTypes.object,
    controlQuestion: PropTypes.object,
    dispatch: PropTypes.func.isRequired,
    humanConfirmation: PropTypes.object,
    canSwitchConfirmationMethod: PropTypes.bool.isRequired,
    toggleConfirmationMethod: PropTypes.func.isRequired
};
