import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import {Button} from '@components/Button';
import {Link} from '@components/Link';
import CountDown from './count_down.jsx';

const ConfirmCodeBtnMobile = (props) => {
    const {
        status,
        btnLinks,
        isPhoneCallConfirmation,
        countDownDone,
        checkCode,
        isMobile,
        isShowCountDown,
        restartTrigger,
        showCodeHint,
        canSwitchConfirmationMethod,
        isMobileRecallButtonExperiment,
        confirmationRetryCountdown
    } = props;
    const toggleConfirmationData = btnLinks.find((item) => item.name === 'toggleConfirmationMethod');
    const isConfirmWithSmsAvailable = btnLinks.find((item) => item.name === 'confirmWithSms');
    const repeatConfirmAction = btnLinks.find((item) => item.name === 'makeCallAgain' || item.name === 'sendSmsAgain');
    const isCallConfirmationWithSmsBtnShowed =
        (!countDownDone && isConfirmWithSmsAvailable) || (countDownDone && isMobileRecallButtonExperiment);

    return (
        <div className='phone__confirm-buttons'>
            {status !== 'valid' && (
                <Button view='action' size='l' width='max' onClick={checkCode}>
                    {i18n('_AUTH_.confirm_code')}
                </Button>
            )}
            <div
                className={classnames({
                    'countdown-relative': isMobile,
                    'btn-countdown': isShowCountDown,
                    'phone__confirm-button': true
                })}
            >
                {repeatConfirmAction && (
                    <div>
                        {isShowCountDown && (
                            <CountDown
                                confirmationRetryCountdown={confirmationRetryCountdown}
                                restartTrigger={restartTrigger}
                                showCodeHint={showCodeHint}
                            />
                        )}
                        <Button
                            view='pseudo'
                            size='l'
                            width='max'
                            disabled={countDownDone}
                            onClick={repeatConfirmAction.method}
                        >
                            {repeatConfirmAction.text}
                        </Button>
                    </div>
                )}
            </div>
            {isPhoneCallConfirmation && isCallConfirmationWithSmsBtnShowed && (
                <div
                    className={classnames({
                        'countdown-relative': isMobile,
                        'btn-countdown': isShowCountDown,
                        'phone__confirm-button': true
                    })}
                >
                    {isShowCountDown && (
                        <CountDown
                            confirmationRetryCountdown={confirmationRetryCountdown}
                            restartTrigger={restartTrigger}
                            showCodeHint={showCodeHint}
                        />
                    )}
                    <Button
                        view='pseudo'
                        size='l'
                        width='max'
                        disabled={countDownDone}
                        onClick={isConfirmWithSmsAvailable.method}
                    >
                        {isConfirmWithSmsAvailable.text}
                    </Button>
                </div>
            )}
            {canSwitchConfirmationMethod && toggleConfirmationData && (
                <div className='toggle-link'>
                    <Link pseudo={true} onClick={toggleConfirmationData.method}>
                        {toggleConfirmationData.text}
                    </Link>
                </div>
            )}
        </div>
    );
};

ConfirmCodeBtnMobile.propTypes = {
    isMobile: PropTypes.bool.isRequired,
    isPhoneCallConfirmation: PropTypes.bool,
    status: PropTypes.string.isRequired,
    checkCode: PropTypes.func.isRequired,
    isShowCountDown: PropTypes.bool.isRequired,
    countDownDone: PropTypes.bool,
    btnLinks: PropTypes.array,
    restartTrigger: PropTypes.bool,
    showCodeHint: PropTypes.func.isRequired,
    canSwitchConfirmationMethod: PropTypes.bool.isRequired,
    confirmationRetryCountdown: PropTypes.number,
    isMobileRecallButtonExperiment: PropTypes.bool
};

export default ConfirmCodeBtnMobile;
